<?php
function configurarCORS(): void {
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';
    if (APP_DEBUG || in_array($origin, CORS_ORIGINS)) {
        header("Access-Control-Allow-Origin: " . ($origin ?: '*'));
    }
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, PATCH, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
}
