<?php
/**
 * Configuracin de Base de Datos - Usando Variables de Entorno
 * IMPORTANTE: Las credenciales ahora se cargan desde .env
 */

// Cargar variables de entorno desde archivo .env si existe
if (file_exists(__DIR__ . '/../../.env')) {
    $lines = file(__DIR__ . '/../../.env', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        // Ignorar comentarios
        if (strpos(trim($line), '#') === 0) continue;
        
        // Parsear lnea KEY=VALUE
        if (strpos($line, '=') !== false) {
            list($key, $value) = explode('=', $line, 2);
            $_ENV[trim($key)] = trim($value);
        }
    }
}

// Definir constantes de base de datos
define('DB_HOST', $_ENV['DB_HOST'] ?? getenv('DB_HOST') ?? 'localhost');
define('DB_NAME', $_ENV['DB_NAME'] ?? getenv('DB_NAME') ?? 'evolucionamos_ana');
define('DB_USER', $_ENV['DB_USER'] ?? getenv('DB_USER') ?? 'evolucionamos_ana');
define('DB_PASS', $_ENV['DB_PASS'] ?? getenv('DB_PASS') ?? '');
define('DB_CHARSET', 'utf8mb4');

// Validacin crtica de seguridad
if (empty(DB_PASS)) {
    error_log("CR01TICO: DB_PASS no est configurado en variables de entorno");
    if (defined('APP_DEBUG') && APP_DEBUG) {
        die(json_encode([
            'success' => false, 
            'error' => 'Error de configuracin: contrase09a de BD no configurada'
        ]));
    } else {
        die(json_encode([
            'success' => false, 
            'error' => 'Error de configuracin del sistema'
        ]));
    }
}

/**
 * Obtener conexin PDO a la base de datos
 */
function getDB(): PDO {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $dsn = sprintf('mysql:host=%s;dbname=%s;charset=%s', DB_HOST, DB_NAME, DB_CHARSET);
            $pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci, time_zone = '-05:00'",
                PDO::ATTR_STRINGIFY_FETCHES  => false,
            ]);
        } catch (PDOException $e) {
            error_log("Error de conexin a BD: " . $e->getMessage());
            http_response_code(500);
            echo json_encode([
                'success' => false, 
                'error' => 'Error de conexin a la base de datos',
                'detail' => (defined('APP_DEBUG') && APP_DEBUG) ? $e->getMessage() : null
            ]);
            exit;
        }
    }
    
    return $pdo;
}