<?php
/**
 * NEXUS IT - Audit Service
 * Registro detallado de todas las operaciones del sistema
 */
class AuditService {

    public static function log(string $accion, string $entidadTipo, ?int $entidadId = null, $datosAnteriores = null, $datosNuevos = null): void {
        try {
            $db = getDB();
            $userId = null;
            try {
                $payload = AuthMiddleware::verificar();
                $userId = $payload['sub'] ?? null;
            } catch (\Exception $e) {}

            // Try full insert first, fallback to basic if columns don't exist
            try {
                $stmt = $db->prepare("INSERT INTO log_actividad (usuario_id, accion, entidad_tipo, entidad_id, datos_anteriores, datos_nuevos, ip_address, user_agent, created_at) VALUES (?,?,?,?,?,?,?,?,NOW())");
                $stmt->execute([
                    $userId, $accion, $entidadTipo, $entidadId,
                    $datosAnteriores ? json_encode($datosAnteriores, JSON_UNESCAPED_UNICODE) : null,
                    $datosNuevos ? json_encode($datosNuevos, JSON_UNESCAPED_UNICODE) : null,
                    $_SERVER['REMOTE_ADDR'] ?? null,
                    substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 500)
                ]);
            } catch (\Exception $e) {
                // Fallback: basic columns only
                $stmt = $db->prepare("INSERT INTO log_actividad (usuario_id, accion, entidad_tipo, entidad_id, ip_address) VALUES (?,?,?,?,?)");
                $stmt->execute([$userId, $accion, $entidadTipo, $entidadId, $_SERVER['REMOTE_ADDR'] ?? null]);
            }
        } catch (\Exception $e) {
            error_log("AuditService error: " . $e->getMessage());
        }
    }

    // Convenience methods
    public static function ticketCreado(int $id, array $data): void { self::log('crear_ticket', 'tickets', $id, null, $data); }
    public static function ticketActualizado(int $id, array $antes, array $despues): void { self::log('actualizar_ticket', 'tickets', $id, $antes, $despues); }
    public static function ticketComentario(int $ticketId): void { self::log('comentar_ticket', 'tickets', $ticketId); }
    public static function activoCreado(int $id, array $data): void { self::log('crear_activo', 'activos', $id, null, $data); }
    public static function activoActualizado(int $id, array $antes, array $despues): void { self::log('actualizar_activo', 'activos', $id, $antes, $despues); }
    public static function usuarioCreado(int $id): void { self::log('crear_usuario', 'usuarios', $id); }
    public static function usuarioActualizado(int $id): void { self::log('actualizar_usuario', 'usuarios', $id); }
    public static function loginExitoso(int $userId): void { self::log('login', 'usuarios', $userId); }
    public static function loginFallido(string $email): void { self::log('login_fallido', 'usuarios', null, ['email' => $email]); }
    public static function cambioPassword(int $userId): void { self::log('cambio_password', 'usuarios', $userId); }
    public static function configActualizada(array $cambios): void { self::log('actualizar_configuracion', 'configuracion', null, null, $cambios); }
    public static function categoriaCreada(int $id): void { self::log('crear_categoria', 'categorias', $id); }
    public static function mantenimientoCreado(int $id): void { self::log('crear_mantenimiento', 'mantenimientos', $id); }
    public static function alertaResuelta(int $id): void { self::log('resolver_alerta', 'alertas', $id); }
    public static function kbArticuloCreado(int $id): void { self::log('crear_articulo_kb', 'articulos_kb', $id); }
}
