<?php
class FileUpload {
    public static function handle(string $fieldName, string $subDir = 'tickets'): ?array {
        if (!isset($_FILES[$fieldName]) || $_FILES[$fieldName]['error'] !== UPLOAD_ERR_OK) return null;

        $file = $_FILES[$fieldName];
        if ($file['size'] > UPLOAD_MAX_SIZE) Response::error('Archivo muy grande (máx 10MB)');
        $mime = mime_content_type($file['tmp_name']);
        if (!in_array($mime, UPLOAD_ALLOWED_TYPES)) Response::error('Tipo de archivo no permitido');

        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $newName = uniqid() . '_' . time() . '.' . $ext;
        $dir = UPLOAD_DIR . '/' . $subDir;
        if (!is_dir($dir)) mkdir($dir, 0755, true);
        $path = $dir . '/' . $newName;

        if (!move_uploaded_file($file['tmp_name'], $path)) Response::serverError('Error al subir archivo');

        return [
            'nombre_original' => $file['name'],
            'nombre_servidor' => $newName,
            'ruta' => $subDir . '/' . $newName,
            'mime_type' => $mime,
            'tamano' => $file['size']
        ];
    }
}
