<?php
class Response {
    public static function success($data = null, string $message = 'OK', int $code = 200): void {
        http_response_code($code);
        echo json_encode(['success' => true, 'message' => $message, 'data' => $data], JSON_UNESCAPED_UNICODE);
        exit;
    }

    public static function paginated(array $data, int $total, int $page, int $perPage): void {
        http_response_code(200);
        echo json_encode([
            'success' => true, 'data' => $data,
            'meta' => ['total' => $total, 'page' => $page, 'per_page' => $perPage,
                       'total_pages' => (int)ceil($total / $perPage), 'has_more' => ($page * $perPage) < $total]
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }

    public static function error(string $message, int $code = 400, $errors = null): void {
        http_response_code($code);
        $r = ['success' => false, 'message' => $message];
        if ($errors !== null) $r['errors'] = $errors;
        echo json_encode($r, JSON_UNESCAPED_UNICODE);
        exit;
    }

    public static function unauthorized(string $m = 'No autorizado'): void { self::error($m, 401); }
    public static function forbidden(string $m = 'No tienes permisos'): void { self::error($m, 403); }
    public static function notFound(string $m = 'Recurso no encontrado'): void { self::error($m, 404); }
    public static function validationError(array $e): void { self::error('Error de validación', 422, $e); }
    public static function serverError(string $m = 'Error interno del servidor'): void { self::error($m, 500); }
    public static function created($data = null, string $m = 'Creado exitosamente'): void { self::success($data, $m, 201); }
    public static function noContent(): void { http_response_code(204); exit; }
}
