<?php
class RateLimiter {
    public static function verificar(int $maxRequests = 120, int $windowSeconds = 60): void {
        // Simple rate limiter using temp files
        $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $key = md5($ip);
        $file = sys_get_temp_dir() . "/nexus_rl_$key";
        
        $data = ['count' => 0, 'reset' => time() + $windowSeconds];
        if (file_exists($file)) {
            $data = json_decode(file_get_contents($file), true) ?: $data;
            if (time() > $data['reset']) {
                $data = ['count' => 0, 'reset' => time() + $windowSeconds];
            }
        }
        
        $data['count']++;
        file_put_contents($file, json_encode($data));
        
        if ($data['count'] > $maxRequests) {
            Response::error('Demasiadas peticiones. Intenta en un momento.', 429);
        }
    }
}
