<?php
/**
 * NEXUS IT — RoleMiddleware
 * Jerarquía: admin > supervisor > tecnico > usuario
 */
class RoleMiddleware {

    public static function requireRole(array $payload, string ...$roles): void {
        $userRole = $payload['rol'] ?? '';
        if (!in_array($userRole, $roles)) {
            Response::forbidden('No tienes permisos para esta acción');
        }
    }

    /** Solo administrador */
    public static function requireAdmin(array $payload): void {
        self::requireRole($payload, 'admin');
    }

    /** Admin + Supervisor (gerentes, directivos) */
    public static function requireSupervisor(array $payload): void {
        self::requireRole($payload, 'admin', 'supervisor');
    }

    /** Admin + Supervisor + Técnico */
    public static function requireTecnico(array $payload): void {
        self::requireRole($payload, 'admin', 'supervisor', 'tecnico');
    }

    /** Cualquier usuario autenticado */
    public static function requireAuth(array $payload): void {
        if (empty($payload['rol'])) {
            Response::forbidden('No autenticado');
        }
    }

    // === Helpers booleanos ===
    public static function isAdmin(array $payload): bool {
        return ($payload['rol'] ?? '') === 'admin';
    }

    public static function isAdminOrSupervisor(array $payload): bool {
        return in_array($payload['rol'] ?? '', ['admin', 'supervisor']);
    }

    public static function isTecnicoOrAbove(array $payload): bool {
        return in_array($payload['rol'] ?? '', ['admin', 'supervisor', 'tecnico']);
    }

    public static function canManage(array $payload): bool {
        return in_array($payload['rol'] ?? '', ['admin', 'supervisor', 'tecnico']);
    }

    // Alias retrocompatibles (tecnico_n2 y auditor se unifican)
    public static function requireAuditor(array $payload): void {
        self::requireSupervisor($payload);
    }

    public static function requireStaff(array $payload): void {
        self::requireTecnico($payload);
    }
}
