<?php
class UsuarioController {
    public static function index(): void {
        $payload = AuthMiddleware::verificar();
        RoleMiddleware::requireTecnico($payload);
        $db = getDB();
        $page = max(1, (int)($_GET['page'] ?? 1));
        $perPage = min(100, max(1, (int)($_GET['per_page'] ?? 20)));
        $offset = ($page - 1) * $perPage;

        $where = ["1=1"]; $params = [];
        if (!empty($_GET['rol'])) { $where[] = "rol = ?"; $params[] = $_GET['rol']; }
        if (!empty($_GET['buscar'])) { $s = '%'.$_GET['buscar'].'%'; $where[] = "(nombre_completo LIKE ? OR email LIKE ?)"; $params = array_merge($params, [$s,$s]); }
        if (isset($_GET['activo'])) { $where[] = "activo = ?"; $params[] = (int)$_GET['activo']; }

        $whereStr = implode(' AND ', $where);
        $countStmt = $db->prepare("SELECT COUNT(*) FROM usuarios WHERE $whereStr");
        $countStmt->execute($params);
        $total = (int)$countStmt->fetchColumn();

        $stmt = $db->prepare("SELECT id, nombre_completo, email, rol, departamento, telefono, activo, ultimo_login, created_at FROM usuarios WHERE $whereStr ORDER BY nombre_completo LIMIT $perPage OFFSET $offset");
        $stmt->execute($params);
        Response::paginated($stmt->fetchAll(), $total, $page, $perPage);
    }

    public static function ver(int $id): void {
        $payload = AuthMiddleware::verificar();
        $db = getDB();
        $stmt = $db->prepare("SELECT id, nombre_completo, email, rol, departamento, telefono, activo, avatar_url, ultimo_login, created_at FROM usuarios WHERE id = ?");
        $stmt->execute([$id]);
        $user = $stmt->fetch();
        if (!$user) Response::notFound('Usuario no encontrado');
        Response::success($user);
    }

    public static function actualizar(int $id): void {
        $payload = AuthMiddleware::verificar();
        $db = getDB();

        // Users can edit their own profile, admins can edit anyone
        $isOwn = (int)$payload['sub'] === $id;
        if (!$isOwn) RoleMiddleware::requireAdmin($payload);

        $body = Validator::getBody();
        $fields = []; $params = [];

        // Fields anyone can edit on their own profile
        $selfAllowed = ['nombre_completo','departamento','telefono'];
        // Additional fields only admins can change
        $adminAllowed = ['email','rol','activo'];

        foreach ($selfAllowed as $f) {
            if (array_key_exists($f, $body)) { $fields[] = "$f = ?"; $params[] = $body[$f]; }
        }
        if ($payload['rol'] === 'admin') {
            foreach ($adminAllowed as $f) {
                if (array_key_exists($f, $body)) { $fields[] = "$f = ?"; $params[] = $body[$f]; }
            }
        }
        if (!empty($body['password']) && $payload['rol'] === 'admin') {
            $fields[] = "password_hash = ?"; $params[] = password_hash($body['password'], PASSWORD_BCRYPT);
        }
        if (empty($fields)) Response::error('Nada que actualizar');

        $params[] = $id;
        $db->prepare("UPDATE usuarios SET " . implode(', ', $fields) . " WHERE id = ?")->execute($params);

        // Log
        try { $db->prepare("INSERT INTO log_actividad (usuario_id, accion, entidad_tipo, entidad_id, ip_address) VALUES (?,?,?,?,?)")
            ->execute([$payload['sub'], 'actualizar_usuario', 'usuarios', $id, $_SERVER['REMOTE_ADDR'] ?? null]); } catch(\Exception $e) {}

        Response::success(null, 'Usuario actualizado');
    }

    public static function tecnicos(): void {
        $payload = AuthMiddleware::verificar();
        $db = getDB();
        $stmt = $db->query("SELECT u.id, u.nombre_completo, u.email, u.rol,
            (SELECT COUNT(*) FROM tickets t WHERE t.tecnico_asignado_id = u.id AND t.estado IN ('abierto','en_progreso','pendiente')) as tickets_activos
            FROM usuarios u WHERE u.rol IN ('admin','supervisor','tecnico') AND u.activo = 1 ORDER BY u.nombre_completo");
        Response::success($stmt->fetchAll());
    }

    public static function departamentos(): void {
        AuthMiddleware::verificar();
        $db = getDB();
        $stmt = $db->query("SELECT DISTINCT departamento FROM usuarios WHERE departamento IS NOT NULL AND departamento != '' ORDER BY departamento");
        Response::success($stmt->fetchAll(PDO::FETCH_COLUMN));
    }
}
