<?php
class JWT {
    public static function generar(array $payload, int $expiration = null): string {
        $header = ['typ' => 'JWT', 'alg' => JWT_ALGORITHM];
        $payload['iat'] = time();
        $payload['exp'] = time() + ($expiration ?? JWT_EXPIRATION);
        $payload['jti'] = bin2hex(random_bytes(16));
        $h = self::b64e(json_encode($header));
        $p = self::b64e(json_encode($payload));
        $sig = self::b64e(hash_hmac('sha256', "$h.$p", JWT_SECRET, true));
        return "$h.$p.$sig";
    }

    public static function validar(string $token): array|false {
        $parts = explode('.', $token);
        if (count($parts) !== 3) return false;
        [$h, $p, $s] = $parts;
        $sig = self::b64e(hash_hmac('sha256', "$h.$p", JWT_SECRET, true));
        if (!hash_equals($sig, $s)) return false;
        $payload = json_decode(self::b64d($p), true);
        if (!$payload || (isset($payload['exp']) && $payload['exp'] < time())) return false;
        return $payload;
    }

    public static function generarRefreshToken(array $payload): string {
        return self::generar($payload, JWT_REFRESH_EXPIRATION);
    }

    public static function extraerDelHeader(): ?string {
        $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
        return preg_match('/Bearer\s+(.+)$/i', $h, $m) ? $m[1] : null;
    }

    private static function b64e(string $d): string { return rtrim(strtr(base64_encode($d), '+/', '-_'), '='); }
    private static function b64d(string $d): string { return base64_decode(strtr($d, '-_', '+/')); }
}
