<?php
class AuthMiddleware {
    public static function verificar(): array {
        $token = JWT::extraerDelHeader();
        if (!$token) Response::error('Token de acceso no proporcionado', 401);
        $payload = JWT::validar($token);
        if (!$payload) Response::error('Token inválido o expirado', 401);
        return $payload;
    }

    public static function opcional(): ?array {
        $token = JWT::extraerDelHeader();
        if (!$token) return null;
        return JWT::validar($token) ?: null;
    }
}
