<?php
header('Content-Type: text/plain');
$logFile = ini_get('error_log');
if ($logFile && file_exists($logFile)) {
    $lines = file($logFile);
    $debug = array_filter($lines, fn($l) => strpos($l, 'EMAIL_DEBUG') !== false);
    echo "=== EMAIL_DEBUG entries ===\n";
    echo implode('', array_slice($debug, -20));
} else {
    echo "Log file: $logFile\n";
    // Try common locations
    $paths = ['/tmp/php_errors.log', '/home/evolucionamos/logs/error.log', '/var/log/apache2/error.log'];
    foreach ($paths as $p) {
        if (file_exists($p)) {
            $lines = file($p);
            $debug = array_filter($lines, fn($l) => strpos($l, 'EMAIL_DEBUG') !== false);
            echo "Found in $p:\n";
            echo implode('', array_slice($debug, -20));
            break;
        }
    }
}
