/**
 * NEXUS IT — Utilidades Frontend v2
 * Badges sin emojis, dots de color puro CSS
 */
const NexusUtils = {
    toast(message, type='info', duration=4000) {
        let c = document.querySelector('.toast-container');
        if (!c) { c = document.createElement('div'); c.className='toast-container'; document.body.appendChild(c); }
        const icons = {success:'✓',error:'✕',warning:'!',info:'i'};
        const t = document.createElement('div');
        t.className = `toast ${type}`;
        t.innerHTML = `<span style="font-weight:700;margin-right:4px">${icons[type]||''}</span> ${message}`;
        c.appendChild(t);
        setTimeout(() => { t.style.opacity='0'; t.style.transform='translateX(100px)'; t.style.transition='0.3s'; setTimeout(()=>t.remove(),300); }, duration);
    },
    success(m) { this.toast(m,'success'); },
    error(m) { this.toast(m,'error'); },
    warning(m) { this.toast(m,'warning'); },
    info(m) { this.toast(m,'info'); },

    formatDate(d) { if(!d) return '—'; return new Date(d).toLocaleDateString('es-CO',{day:'2-digit',month:'short',year:'numeric'}); },
    formatDateTime(d) { if(!d) return '—'; return new Date(d).toLocaleDateString('es-CO',{day:'2-digit',month:'short',year:'numeric',hour:'2-digit',minute:'2-digit'}); },
    
    timeAgo(d) {
        if(!d) return '';
        const s = Math.floor((new Date()-new Date(d))/1000);
        if(s<60) return 'hace un momento';
        if(s<3600) return `hace ${Math.floor(s/60)} min`;
        if(s<86400) return `hace ${Math.floor(s/3600)}h`;
        if(s<604800) return `hace ${Math.floor(s/86400)}d`;
        return this.formatDate(d);
    },

    formatMoney(a) { if(!a&&a!==0) return '—'; return new Intl.NumberFormat('es-CO',{style:'currency',currency:'COP',minimumFractionDigits:0}).format(a); },
    formatBytes(b) { if(!b) return '0 B'; const k=1024,s=['B','KB','MB','GB']; const i=Math.floor(Math.log(b)/Math.log(k)); return parseFloat((b/Math.pow(k,i)).toFixed(1))+' '+s[i]; },

    // ── Dot helper: small colored circle ──
    _dot(color) {
        return `<span style="display:inline-block;width:8px;height:8px;border-radius:50%;background:${color};flex-shrink:0"></span>`;
    },

    badgeEstado(e) {
        const conf = {
            abierto:     { label: 'Abierto',      dot: '#2563eb' },
            en_progreso: { label: 'En Progreso',   dot: '#d97706' },
            pendiente:   { label: 'Pendiente',     dot: '#7c3aed' },
            resuelto:    { label: 'Resuelto',      dot: '#059669' },
            cerrado:     { label: 'Cerrado',       dot: '#6b7280' },
            reabierto:   { label: 'Reabierto',     dot: '#db2777' }
        };
        const c = conf[e] || { label: e, dot: '#6b7280' };
        return `<span class="badge badge-${e}">${this._dot(c.dot)} ${c.label}</span>`;
    },

    badgePrioridad(p) {
        const conf = {
            baja:    { label: 'Baja',    dot: '#059669' },
            media:   { label: 'Media',   dot: '#d97706' },
            alta:    { label: 'Alta',    dot: '#ea580c' },
            critica: { label: 'Crítica', dot: '#dc2626' },
            urgente: { label: 'Urgente', dot: '#dc2626' }
        };
        const c = conf[p] || { label: p, dot: '#6b7280' };
        return `<span class="badge badge-${p}">${this._dot(c.dot)} ${c.label}</span>`;
    },

    badgeEstadoActivo(e) {
        const c = {activo:'badge-resuelto', mantenimiento:'badge-en_progreso', baja:'badge-cerrado', bodega:'badge-pendiente'};
        return `<span class="badge ${c[e]||''}">${e}</span>`;
    },

    // ── Rating stars (pure CSS) ──
    stars(n) {
        if (!n) return '—';
        let html = '';
        for (let i = 1; i <= 5; i++) {
            html += `<span style="color:${i <= n ? '#d97706' : '#d1d5db'};font-size:14px">★</span>`;
        }
        return html;
    },

    openModal(id) { document.getElementById(id)?.classList.add('active'); },
    closeModal(id) { document.getElementById(id)?.classList.remove('active'); },
    getParam(n) { return new URLSearchParams(window.location.search).get(n); },

    debounce(func, wait=300) {
        let timeout;
        return function(...args) { clearTimeout(timeout); timeout=setTimeout(()=>func.apply(this,args),wait); };
    }
};

window.NexusUtils = NexusUtils;
