<?php
/**
 * NEXUS IT — Alertas de Contratos y Licencias
 * Cron: Ejecutar 1 vez al día a las 8:00 AM
 * 0 8 * * * /usr/local/bin/php /home/evolucionamos/public_html/ana/cron/check_vencimientos.php
 */
require_once __DIR__ . '/../api/config.php';
require_once __DIR__ . '/../api/helpers/EmailService.php';

echo "[" . date('Y-m-d H:i:s') . "] Verificando vencimientos...\n";

$db = getDB();

// ==========================================
// 1. CONTRATOS POR VENCER
// ==========================================
$contratos = $db->query("SELECT c.*, 
    DATEDIFF(c.fecha_fin, CURDATE()) as dias_restantes,
    (SELECT COUNT(*) FROM contrato_activos ca WHERE ca.contrato_id = c.id) as total_activos
    FROM contratos_soporte c 
    WHERE c.activo = 1 
    AND c.fecha_fin >= CURDATE() 
    AND c.fecha_fin <= DATE_ADD(CURDATE(), INTERVAL c.alerta_dias DAY)")->fetchAll();

foreach ($contratos as $c) {
    echo "CONTRATO POR VENCER: {$c['nombre']} — {$c['proveedor']} — vence en {$c['dias_restantes']} días\n";

    // Notificar admins y supervisores
    $admins = $db->query("SELECT id, email, nombre_completo FROM usuarios WHERE rol IN ('admin','supervisor') AND activo = 1")->fetchAll();
    foreach ($admins as $admin) {
        // Evitar spam: solo 1 vez por semana
        $ya = $db->prepare("SELECT id FROM notificaciones WHERE usuario_id = ? AND referencia_tipo = 'contrato_vencimiento' AND referencia_id = ? AND created_at > DATE_SUB(NOW(), INTERVAL 7 DAY)");
        $ya->execute([$admin['id'], $c['id']]);
        if ($ya->fetch()) continue;

        $db->prepare("INSERT INTO notificaciones (usuario_id, titulo, mensaje, tipo, referencia_tipo, referencia_id) VALUES (?,?,?,?,?,?)")
            ->execute([$admin['id'], "Contrato por vencer: {$c['nombre']}", "Vence en {$c['dias_restantes']} días — Proveedor: {$c['proveedor']}", 'alerta', 'contrato_vencimiento', $c['id']]);

        // Email
        if (class_exists('EmailService') && $admin['email']) {
            try {
                $vars = [
                    'nombre_contrato' => $c['nombre'], 'proveedor' => $c['proveedor'],
                    'numero_contrato' => $c['numero_contrato'] ?? '', 'fecha_vencimiento' => $c['fecha_fin'],
                    'dias_restantes' => $c['dias_restantes'], 'cantidad_activos' => $c['total_activos'],
                    'nombre_empresa' => 'Nexus IT'
                ];
                $rendered = EmailService::renderPlantilla('contrato_por_vencer', $vars, '', '');
                if ($rendered) EmailService::enviar($admin['email'], $rendered['asunto'], $rendered['html']);
            } catch (\Exception $e) {}
        }
    }
}

// ==========================================
// 2. LICENCIAS POR VENCER
// ==========================================
$licencias = $db->query("SELECT l.*,
    DATEDIFF(l.fecha_vencimiento, CURDATE()) as dias_restantes
    FROM licencias_software l 
    WHERE l.activo = 1 
    AND l.fecha_vencimiento IS NOT NULL
    AND l.fecha_vencimiento >= CURDATE() 
    AND l.fecha_vencimiento <= DATE_ADD(CURDATE(), INTERVAL l.alerta_renovacion_dias DAY)")->fetchAll();

foreach ($licencias as $l) {
    echo "LICENCIA POR VENCER: {$l['nombre']} — vence en {$l['dias_restantes']} días\n";

    $admins = $db->query("SELECT id, email FROM usuarios WHERE rol IN ('admin','supervisor') AND activo = 1")->fetchAll();
    foreach ($admins as $admin) {
        $ya = $db->prepare("SELECT id FROM notificaciones WHERE usuario_id = ? AND referencia_tipo = 'licencia_vencimiento' AND referencia_id = ? AND created_at > DATE_SUB(NOW(), INTERVAL 7 DAY)");
        $ya->execute([$admin['id'], $l['id']]);
        if ($ya->fetch()) continue;

        $db->prepare("INSERT INTO notificaciones (usuario_id, titulo, mensaje, tipo, referencia_tipo, referencia_id) VALUES (?,?,?,?,?,?)")
            ->execute([$admin['id'], "Licencia por vencer: {$l['nombre']}", "Vence en {$l['dias_restantes']} días — {$l['cantidad_usada']}/{$l['cantidad_total']} en uso", 'alerta', 'licencia_vencimiento', $l['id']]);

        if (class_exists('EmailService') && $admin['email']) {
            try {
                $vars = [
                    'nombre_licencia' => $l['nombre'], 'editor' => $l['editor'] ?? '',
                    'fecha_vencimiento' => $l['fecha_vencimiento'], 'dias_restantes' => $l['dias_restantes'],
                    'cantidad_total' => $l['cantidad_total'], 'cantidad_usada' => $l['cantidad_usada'],
                    'nombre_empresa' => 'Nexus IT'
                ];
                $rendered = EmailService::renderPlantilla('licencia_por_vencer', $vars, '', '');
                if ($rendered) EmailService::enviar($admin['email'], $rendered['asunto'], $rendered['html']);
            } catch (\Exception $e) {}
        }
    }
}

// ==========================================
// 3. GARANTÍAS DE ACTIVOS POR VENCER
// ==========================================
$garantias = $db->query("SELECT a.id, a.nombre, a.codigo_interno, a.marca, a.modelo, a.garantia_hasta,
    DATEDIFF(a.garantia_hasta, CURDATE()) as dias_restantes,
    u.nombre_completo as usuario_asignado
    FROM activos a 
    LEFT JOIN usuarios u ON a.usuario_asignado_id = u.id
    WHERE a.garantia_hasta IS NOT NULL 
    AND a.garantia_hasta >= CURDATE() 
    AND a.garantia_hasta <= DATE_ADD(CURDATE(), INTERVAL 30 DAY)")->fetchAll();

foreach ($garantias as $g) {
    echo "GARANTÍA POR VENCER: {$g['nombre']} ({$g['codigo_interno']}) — {$g['dias_restantes']} días\n";

    $admins = $db->query("SELECT id FROM usuarios WHERE rol IN ('admin','supervisor') AND activo = 1")->fetchAll();
    foreach ($admins as $admin) {
        $ya = $db->prepare("SELECT id FROM notificaciones WHERE usuario_id = ? AND referencia_tipo = 'garantia_vencimiento' AND referencia_id = ? AND created_at > DATE_SUB(NOW(), INTERVAL 7 DAY)");
        $ya->execute([$admin['id'], $g['id']]);
        if ($ya->fetch()) continue;

        $db->prepare("INSERT INTO notificaciones (usuario_id, titulo, mensaje, tipo, url_accion, referencia_tipo, referencia_id) VALUES (?,?,?,?,?,?,?)")
            ->execute([$admin['id'], "Garantía por vencer: {$g['codigo_interno']}", "{$g['nombre']} ({$g['marca']} {$g['modelo']}) — vence en {$g['dias_restantes']} días", 'alerta', "/admin/activo-detalle.html?id={$g['id']}", 'garantia_vencimiento', $g['id']]);
    }
}

echo "[" . date('Y-m-d H:i:s') . "] Verificación completada.\n";
echo "Contratos alertados: " . count($contratos) . "\n";
echo "Licencias alertadas: " . count($licencias) . "\n";
echo "Garantías alertadas: " . count($garantias) . "\n";
