<?php
/**
 * NEXUS IT - Cron: Recordatorios de Mantenimiento
 * Ejecutar diariamente via cPanel Cron Jobs
 * Comando: php /home/USUARIO/public_html/ana/cron/send_reminders.php
 */

require_once dirname(__DIR__) . '/api/config/app.php';
require_once dirname(__DIR__) . '/api/config/database.php';

$db = getDB();

echo "[" . date('Y-m-d H:i:s') . "] Enviando recordatorios...\n";

$diasAnticipacion = 7;
$stmt = $db->prepare("SELECT valor FROM configuracion WHERE clave = 'mant_dias_anticipacion'");
$stmt->execute();
$val = $stmt->fetchColumn();
if ($val) $diasAnticipacion = (int)$val;

// Mantenimientos próximos a vencer
$stmt = $db->prepare("
    SELECT m.*, a.codigo_activo, a.marca AS activo_marca, a.modelo AS activo_modelo
    FROM mantenimientos m
    LEFT JOIN activos a ON m.activo_id = a.id
    WHERE m.estado = 'programado'
    AND m.fecha_programada BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL ? DAY)
");
$stmt->execute([$diasAnticipacion]);
$pendientes = $stmt->fetchAll();

$notificados = 0;

$stmtNotif = $db->prepare("
    INSERT INTO notificaciones (usuario_id, titulo, mensaje, tipo, referencia_tipo, referencia_id)
    VALUES (?, ?, ?, 'mantenimiento', 'mantenimiento', ?)
");

// Verificar que no se duplique la notificación del mismo día
$stmtCheck = $db->prepare("
    SELECT COUNT(*) FROM notificaciones 
    WHERE referencia_tipo = 'mantenimiento' AND referencia_id = ? AND DATE(created_at) = CURDATE()
");

foreach ($pendientes as $m) {
    if (!$m['tecnico_id']) continue;
    
    $stmtCheck->execute([$m['id']]);
    if ($stmtCheck->fetchColumn() > 0) continue;
    
    $dias = (int)((strtotime($m['fecha_programada']) - time()) / 86400);
    $equipo = $m['codigo_activo'] . ' (' . ($m['activo_marca'] ?? '') . ' ' . ($m['activo_modelo'] ?? '') . ')';
    
    $stmtNotif->execute([
        $m['tecnico_id'],
        "Mantenimiento en {$dias} días",
        "{$m['titulo']} — Equipo: {$equipo} — Fecha: {$m['fecha_programada']}",
        $m['id']
    ]);
    $notificados++;
}

// Mantenimientos vencidos (fecha pasada, aún programados)
$stmt = $db->query("
    SELECT m.*, a.codigo_activo FROM mantenimientos m
    LEFT JOIN activos a ON m.activo_id = a.id
    WHERE m.estado = 'programado' AND m.fecha_programada < CURDATE()
");

while ($m = $stmt->fetch()) {
    if (!$m['tecnico_id']) continue;
    
    $stmtCheck->execute([$m['id']]);
    if ($stmtCheck->fetchColumn() > 0) continue;
    
    $stmtNotif->execute([
        $m['tecnico_id'],
        "⚠️ Mantenimiento vencido",
        "{$m['titulo']} — Equipo: {$m['codigo_activo']} — Debía hacerse el {$m['fecha_programada']}",
        $m['id']
    ]);
    $notificados++;
}

echo "Notificaciones enviadas: $notificados\n";
