const pool = require('../config/db');

async function logAction(userId, userName, action, entityType, entityId, oldVal, newVal, ip) {
  try {
    await pool.query(
      `INSERT INTO audit_log (user_id, user_name, action, entity_type, entity_id, old_values, new_values, ip_address) VALUES (?,?,?,?,?,?,?,?)`,
      [userId, userName, action, entityType, entityId, oldVal ? JSON.stringify(oldVal) : null, newVal ? JSON.stringify(newVal) : null, ip || null]
    );
  } catch (e) { console.error('Audit error:', e.message); }
}

module.exports = { logAction };
