# HelpDesk ITSM v2.0 — Documentación Técnica

## 1. Visión General

HelpDesk ITSM es una plataforma de gestión de servicios de TI que permite a las organizaciones gestionar tickets de soporte, inventario de activos, base de conocimiento, y monitoreo de SLAs, con integración opcional de Inteligencia Artificial.

## 2. Stack Tecnológico

| Componente | Tecnología |
|-----------|-----------|
| Backend | Node.js 18+ / Express 4.x |
| Base de datos | MySQL 8+ / MariaDB 10.4+ |
| Autenticación | JWT (jsonwebtoken) |
| Contraseñas | bcryptjs (hash + salt) |
| Frontend | HTML5 + Tailwind CSS (CDN) + JS ES6 Modules |
| Email | Nodemailer (SMTP/Gmail) |
| IA | Google Gemini API (opcional) |
| Archivos | Multer (upload) |

## 3. Arquitectura

```
Monolito Modular con separación clara:

backend/
├── config/         → Conexión DB, email
├── middlewares/     → Auth JWT, roles
├── routes/          → Endpoints REST
├── services/        → IA, auditoría, notificaciones
└── server.js        → Entry point

public/
├── js/             → SPA modules (auth, ui, app)
├── css/            → Estilos
├── uploads/        → Archivos adjuntos
└── index.html      → Shell SPA
```

### Patrón: SPA + REST API
- Frontend: Single Page Application con hash routing
- Backend: API REST pura con JSON
- Separación total frontend/backend

## 4. Modelo de Datos (Entidad-Relación)

### Tablas principales:
- **users** — Usuarios con roles (admin, agent, client)
- **tickets** — Tickets con prioridad, SLA, categoría, asignación
- **ticket_comments** — Conversación tipo hilo
- **ticket_attachments** — Archivos adjuntos seguros
- **ticket_statuses** — Estados configurables
- **ticket_categories** — Categorías/subcategorías parametrizables
- **sla_policies** — Políticas SLA por prioridad
- **assets** — Inventario CMDB
- **asset_maintenance** — Historial de mantenimientos
- **kb_articles** — Base de conocimiento con fulltext search
- **kb_categories** — Categorías de artículos
- **audit_log** — Trazabilidad completa (JSON old/new values)
- **notifications** — Notificaciones in-app
- **login_attempts** — Rate limiting
- **settings** — Configuración key-value

### Relaciones clave:
- ticket → status, category, subcategory, assigned_to(user), created_by(user), asset, sla_policy
- asset → assigned_to(user), maintenance history, related tickets
- comment → ticket, user
- audit_log → entity_type + entity_id (polimórfico)

## 5. Seguridad

- **Passwords**: bcrypt con salt (costo 10)
- **Autenticación**: JWT con expiración configurable
- **Rate limiting**: Tabla login_attempts, bloqueo 15 min tras 10 intentos
- **IDOR**: Clientes solo ven sus propios tickets
- **Roles**: Middleware requireRole() por endpoint
- **Archivos**: Validación extensión + límite 10MB
- **SQL Injection**: Consultas parametrizadas (mysql2/promise)

## 6. Módulos Funcionales

### 6.1 Ticketing
- Crear, listar, filtrar, detalle
- Estados dinámicos configurables
- Prioridades: low, medium, high, critical
- SLA automático según prioridad
- Comentarios tipo conversación (públicos e internos)
- Adjuntos seguros
- Relación ticket-activo
- Calificación de satisfacción
- First response tracking

### 6.2 CMDB (Inventario)
- CRUD de activos (8 tipos)
- Asset tags únicos
- Historial de mantenimientos
- Relación con tickets
- Asignación a usuarios

### 6.3 Base de Conocimiento
- Artículos con categorías
- Búsqueda fulltext (MySQL)
- Publicación/borrador/archivado
- Contador de vistas
- Feedback útil/no útil
- Artículos fijados (pinned)

### 6.4 Dashboard
- KPIs: tickets abiertos, resueltos hoy, SLA vencidos, tiempo respuesta
- Distribución por estado y prioridad
- Rendimiento de agentes
- Tickets recientes
- Vista diferenciada por rol

### 6.5 Notificaciones
- In-app (tabla notifications)
- Email automático (ticket creado, estado cambiado, comentario)
- Funciona sin email configurado (modo simulado)

### 6.6 Trazabilidad
- Tabla audit_log con JSON de valores anteriores/nuevos
- Registro de: login, CRUD tickets, activos, usuarios, comentarios
- IP del cliente

## 7. Integración IA (Gemini)

### Capacidades:
- Análisis automático al crear ticket
- Sugerencia de respuesta para agentes
- Detección de urgencia
- Sugerencia de artículo KB relacionado

### Flujo:
1. Cliente crea ticket
2. AI analiza (no bloqueante)
3. Resultado se guarda en ticket.ai_summary
4. Agente ve sugerencia y puede usarla

### Configuración:
- API Key se configura en Settings (panel admin)
- Funciona completamente sin IA (graceful degradation)

## 8. API REST

| Método | Endpoint | Descripción |
|--------|---------|-------------|
| POST | /api/auth/login | Login |
| GET | /api/auth/me | Perfil usuario |
| GET/POST | /api/tickets | Listar/Crear tickets |
| GET/PUT | /api/tickets/:id | Detalle/Actualizar ticket |
| POST | /api/tickets/:id/comments | Agregar comentario |
| GET | /api/tickets/:id/ai-suggest | Sugerencia IA |
| GET/POST | /api/assets | Listar/Crear activos |
| GET/PUT | /api/assets/:id | Detalle/Actualizar activo |
| POST | /api/assets/:id/maintenance | Agregar mantenimiento |
| GET/POST | /api/knowledge | Listar/Crear artículos |
| GET | /api/dashboard | Métricas dashboard |
| GET/POST | /api/admin/users | Gestión usuarios |
| GET/PUT | /api/admin/settings | Configuración |
| GET | /api/admin/audit | Log de auditoría |

## 9. Instalación

```bash
# 1. Configurar .env con datos de BD
# 2. Instalar dependencias
npm install

# 3. Crear BD y tablas
npm run install-db

# 4. Iniciar
npm start
```

### Usuarios por defecto:
| Rol | Email | Contraseña |
|-----|-------|-----------|
| Admin | admin@laboratorio.com | Laboratorio@2025* |
| Agente | agente@laboratorio.com | Agente2025* |
| Cliente | cliente@laboratorio.com | Cliente2025* |

## 10. Despliegue CPanel

1. Subir proyecto al hosting
2. Configurar .env con datos de BD del CPanel
3. En CPanel → Setup Node.js App → apuntar a backend/server.js
4. Ejecutar npm install
5. Ejecutar npm run install-db
6. Iniciar aplicación

## 11. Roadmap (12-18 meses)

**Fase 1 (actual):** MVP funcional — ticketing, CMDB, KB, dashboard, IA básica
**Fase 2 (3 meses):** Multi-tenancy, planes, reportes avanzados con gráficas
**Fase 3 (6 meses):** API pública, integración WhatsApp/chatbot, SLA avanzado
**Fase 4 (12 meses):** Migración microservicios, búsqueda semántica con embeddings
**Fase 5 (18 meses):** Marketplace de integraciones, mobile app

## 12. Escalabilidad

La arquitectura actual permite evolución a:
- **Multi-tenant**: Agregar company_id a tablas operativas
- **Microservicios**: Separar tickets, assets, KB en servicios independientes
- **Cloud**: Containerización con Docker, despliegue en AWS/GCP
- **Búsqueda semántica**: Reemplazar fulltext por embeddings + vector DB
