import{getUser,clearAuth}from'./auth.js';

export function layout(title,body,active=''){
  const u=getUser();if(!u)return body;
  const isAg=['admin','agent'].includes(u.role),isAd=u.role==='admin';
  const nav=[
    {id:'dashboard',icon:'fa-chart-pie',label:'Dashboard',show:true},
    {id:'tickets',icon:'fa-ticket',label:'Tickets',show:true},
    {id:'assets',icon:'fa-server',label:'Inventario',show:isAg},
    {id:'knowledge',icon:'fa-book',label:'Conocimiento',show:true},
    {id:'_div',show:isAd},
    {id:'users',icon:'fa-users-cog',label:'Usuarios',show:isAd},
    {id:'settings',icon:'fa-cog',label:'Configuración',show:isAd},
  ].filter(n=>n.show);

  return`<div class="flex h-screen overflow-hidden">
  <aside id="sb" class="w-64 bg-gray-800 text-white flex-shrink-0 flex flex-col fixed inset-y-0 left-0 z-30 transform -translate-x-full md:translate-x-0 transition-transform">
    <div class="p-5 border-b border-gray-700"><div class="flex items-center gap-3"><div class="w-10 h-10 bg-[#007A33] rounded-xl flex items-center justify-center"><i class="fas fa-headset text-lg"></i></div><div><h1 class="font-bold text-lg">HelpDesk</h1><p class="text-xs text-gray-400">ITSM v2.0</p></div></div></div>
    <nav class="flex-1 p-3 space-y-1 overflow-y-auto">${nav.map(n=>n.id==='_div'?'<hr class="border-gray-700 my-2">':`<a href="#${n.id}" class="flex items-center gap-3 px-4 py-2.5 rounded-lg transition-colors ${active===n.id?'bg-[#007A33] text-white':'text-gray-300 hover:bg-gray-700'}"><i class="fas ${n.icon} w-5 text-center"></i><span>${n.label}</span></a>`).join('')}</nav>
    <div class="p-3 border-t border-gray-700"><div class="flex items-center gap-3 px-3 py-2"><div class="w-8 h-8 rounded-full bg-[#007A33] flex items-center justify-center text-sm font-bold">${u.name.charAt(0)}</div><div class="flex-1 min-w-0"><p class="text-sm font-medium truncate">${u.name}</p><p class="text-xs text-gray-400 capitalize">${u.role}</p></div><button onclick="document.dispatchEvent(new Event('logout'))" class="text-gray-400 hover:text-red-400" title="Salir"><i class="fas fa-sign-out-alt"></i></button></div></div>
  </aside>
  <div class="flex-1 md:ml-64 flex flex-col overflow-hidden">
    <header class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700 px-6 py-3 flex items-center justify-between flex-shrink-0">
      <div class="flex items-center gap-3"><button onclick="document.getElementById('sb').classList.toggle('-translate-x-full')" class="md:hidden text-gray-600 dark:text-gray-300"><i class="fas fa-bars text-xl"></i></button><h2 class="text-lg font-semibold text-gray-800 dark:text-white">${title}</h2></div>
      <button onclick="document.documentElement.classList.toggle('dark');localStorage.setItem('theme',document.documentElement.classList.contains('dark')?'dark':'light')" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300"><i class="fas fa-moon"></i></button>
    </header>
    <main class="flex-1 overflow-y-auto bg-gray-50 dark:bg-gray-900 p-6">${body}</main>
  </div></div>`;
}

export const loading='<div class="spinner"></div>';

export function kpi(label,val,icon,color){
  const c={blue:'bg-blue-100 text-blue-600 dark:bg-blue-900/30 dark:text-blue-400',green:'bg-green-100 text-green-600 dark:bg-green-900/30',red:'bg-red-100 text-red-600 dark:bg-red-900/30',purple:'bg-purple-100 text-purple-600 dark:bg-purple-900/30'};
  return`<div class="card p-5"><div class="flex items-center justify-between"><div><p class="text-sm text-gray-500 dark:text-gray-400">${label}</p><p class="text-3xl font-bold text-gray-800 dark:text-white mt-1">${val}</p></div><div class="w-12 h-12 rounded-xl ${c[color]} flex items-center justify-center"><i class="fas ${icon} text-xl"></i></div></div></div>`;
}

document.addEventListener('logout',()=>{clearAuth();location.hash='#login'});
if(localStorage.getItem('theme')==='dark')document.documentElement.classList.add('dark');
