require('dotenv').config();
const key = process.env.GEMINI_API_KEY;
console.log('Key:', key ? key.substring(0,10) + '...' : 'MISSING');

const url = `https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=${key}`;
console.log('Calling Gemini...');

fetch(url, {
  method: 'POST',
  headers: { 'Content-Type': 'application/json' },
  body: JSON.stringify({
    contents: [{ parts: [{ text: 'Responde solo: Hola mundo' }] }],
    generationConfig: { temperature: 0.3, maxOutputTokens: 100 }
  })
}).then(async res => {
  console.log('Status:', res.status);
  const data = await res.json();
  console.log('Response:', JSON.stringify(data).substring(0, 500));
}).catch(e => console.log('Fetch error:', e.message));
