# HelpDesk ITSM v2.0

Sistema de Gestión de Servicios de TI — Help Desk / Service Desk profesional.

## Características

- ✅ Gestión completa de tickets con SLA automático
- ✅ Categorías y subcategorías parametrizables
- ✅ 3 roles: Admin, Agente, Cliente
- ✅ Inventario de activos (CMDB) con trazabilidad
- ✅ Base de conocimiento con búsqueda
- ✅ Dashboard con métricas en tiempo real
- ✅ Notificaciones email automáticas
- ✅ Auditoría completa (trazabilidad)
- ✅ Integración IA (Gemini) para análisis y sugerencias
- ✅ Modo claro/oscuro
- ✅ Responsive
- ✅ Seguridad: bcrypt, JWT, rate limiting, IDOR protection

## Instalación Rápida

```bash
# 1. Configurar .env
cp .env.example .env
# Editar con datos de tu BD

# 2. Instalar dependencias
npm install

# 3. Crear base de datos y tablas
npm run install-db

# 4. Iniciar
npm start
```

## Credenciales por defecto

| Rol | Email | Contraseña |
|-----|-------|-----------|
| Admin | admin@laboratorio.com | Laboratorio@2025* |
| Agente | agente@laboratorio.com | Agente2025* |
| Cliente | cliente@laboratorio.com | Cliente2025* |

## Stack

- Backend: Node.js + Express
- BD: MySQL / MariaDB
- Frontend: HTML + Tailwind CSS + JS (SPA)
- Auth: JWT + bcrypt
- IA: Google Gemini (opcional)

## Documentación

Ver `/docs/TECHNICAL_WHITEPAPER.md` para documentación técnica completa.
