import{isLoggedIn,getToken,setAuth,getUser,GET,POST,PUT,ago,fmtDate}from'./auth.js';
import{layout,loading,kpi}from'./ui.js';

const $=id=>document.getElementById(id);
const app=()=>document.getElementById('app');
const main=()=>document.querySelector('main');

function route(){
  const h=location.hash.slice(1)||(getToken()?'dashboard':'login');
  if(h!=='login'&&!getToken()){location.hash='#login';return}
  if(h==='login'&&getToken()){location.hash='#dashboard';return}
  const[pg,...p]=h.split('/');
  const param=p.join('/');
  const routes={login:pgLogin,dashboard:pgDash,tickets:pgTickets,'new-ticket':pgNewTicket,assets:pgAssets,knowledge:pgKB,users:pgUsers,settings:pgSettings};
  (routes[pg]||pg404)(param);
}
window.addEventListener('hashchange',route);
document.addEventListener('DOMContentLoaded',route);

// ═══ LOGIN ═══
function pgLogin(){
  app().innerHTML=`<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800 p-4">
  <div class="w-full max-w-md bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-200 dark:border-gray-700">
    <div class="text-center mb-8"><div class="w-16 h-16 bg-[#007A33] rounded-2xl flex items-center justify-center mx-auto mb-4"><i class="fas fa-headset text-2xl text-white"></i></div><h1 class="text-2xl font-bold text-gray-800 dark:text-white">HelpDesk ITSM</h1><p class="text-sm text-gray-500 mt-1">Sistema de Gestión de Servicios de TI</p></div>
    <form id="lf" class="space-y-5">
      <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Email</label><input id="le" type="email" required class="input-field" placeholder="admin@laboratorio.com"></div>
      <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Contraseña</label><input id="lp" type="password" required class="input-field" placeholder="••••••••"></div>
      <button type="submit" class="btn-primary w-full justify-center"><i class="fas fa-sign-in-alt mr-2"></i>Ingresar</button>
      <div id="lerr" class="hidden p-3 rounded-lg bg-red-50 dark:bg-red-900/30 text-red-600 dark:text-red-400 text-sm text-center"></div>
    </form>
  </div></div>`;
  $('lf').onsubmit=async e=>{e.preventDefault();$('lerr').classList.add('hidden');try{
    const r=await fetch('/api/auth/login',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({email:$('le').value,password:$('lp').value})});
    const d=await r.json();if(!r.ok)throw new Error(d.error);setAuth(d.token,d.user);location.hash='#dashboard';
  }catch(err){$('lerr').textContent=err.message;$('lerr').classList.remove('hidden')}};
}

// ═══ DASHBOARD ═══
async function pgDash(){
  app().innerHTML=layout('Dashboard',loading,'dashboard');
  try{
    const d=await GET('/api/dashboard');const u=getUser();
    main().innerHTML=`<div class="space-y-6">
      <div class="flex flex-wrap justify-between items-center gap-4"><p class="text-gray-500 dark:text-gray-400">Bienvenido, <strong class="text-gray-800 dark:text-white">${u.name}</strong></p><a href="#new-ticket" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nuevo Ticket</a></div>
      <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">${kpi('Abiertos',d.openTickets,'fa-ticket','blue')}${kpi('Resueltos Hoy',d.resolvedToday,'fa-check-circle','green')}${kpi('SLA Vencidos',d.slaBreached,'fa-exclamation-triangle','red')}${kpi('Resp. Promedio',d.avgResponseMinutes+'m','fa-clock','purple')}</div>
      <div class="grid lg:grid-cols-2 gap-6">
        <div class="card p-5"><h3 class="font-semibold dark:text-white mb-4">Por Estado</h3><div class="space-y-3">${d.byStatus.map(s=>`<div class="flex justify-between"><div class="flex items-center gap-2"><div class="w-3 h-3 rounded-full" style="background:${s.color}"></div><span class="text-sm text-gray-600 dark:text-gray-300">${s.name}</span></div><span class="font-bold dark:text-white">${s.count}</span></div>`).join('')}</div></div>
        <div class="card p-5"><h3 class="font-semibold dark:text-white mb-4">Por Prioridad</h3><div class="space-y-3">${d.byPriority.map(p=>`<div class="flex justify-between"><span class="text-sm capitalize text-gray-600 dark:text-gray-300">${p.priority}</span><span class="font-bold dark:text-white">${p.count}</span></div>`).join('')}</div></div>
      </div>
      <div class="card"><div class="p-5 border-b border-gray-200 dark:border-gray-700 flex justify-between"><h3 class="font-semibold dark:text-white">Recientes</h3><a href="#tickets" class="text-sm text-[#007A33] hover:underline">Ver todos →</a></div>
      <div class="overflow-x-auto"><table class="w-full text-sm"><thead class="bg-gray-50 dark:bg-gray-700/50"><tr><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">ID</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Asunto</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Estado</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Prioridad</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Creado</th></tr></thead>
      <tbody class="divide-y divide-gray-100 dark:divide-gray-700">${d.recent.length?d.recent.map(t=>`<tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30 cursor-pointer" onclick="location.hash='#tickets/${t.id}'"><td class="px-5 py-3 font-medium text-[#007A33]">#${t.id}</td><td class="px-5 py-3 dark:text-gray-200">${t.subject}</td><td class="px-5 py-3"><span class="badge text-white" style="background:${t.status_color}">${t.status_name}</span></td><td class="px-5 py-3 capitalize text-gray-600">${t.priority}</td><td class="px-5 py-3 text-gray-500">${ago(t.created_at)}</td></tr>`).join(''):'<tr><td colspan="5" class="px-5 py-10 text-center text-gray-400">No hay tickets</td></tr>'}</tbody></table></div></div>
    </div>`;
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

// ═══ TICKETS LIST ═══
async function pgTickets(param){
  if(param==='new')return pgNewTicket();
  if(param&&!isNaN(param))return pgTicketDetail(param);
  app().innerHTML=layout('Tickets',loading,'tickets');
  try{
    const d=await GET('/api/tickets?limit=50');
    main().innerHTML=`<div class="space-y-4">
      <div class="flex justify-between items-center"><h2 class="text-xl font-bold dark:text-white">${d.total} tickets</h2><a href="#new-ticket" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nuevo</a></div>
      <div class="card overflow-x-auto"><table class="w-full text-sm"><thead class="bg-gray-50 dark:bg-gray-700/50"><tr><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">ID</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Asunto</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Categoría</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Estado</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Prioridad</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Agente</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Fecha</th></tr></thead>
      <tbody class="divide-y divide-gray-100 dark:divide-gray-700">${d.data.length?d.data.map(t=>`<tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30 cursor-pointer" onclick="location.hash='#tickets/${t.id}'"><td class="px-5 py-3 font-medium text-[#007A33]">#${t.id}</td><td class="px-5 py-3 dark:text-gray-200 max-w-xs truncate">${t.subject}</td><td class="px-5 py-3 text-gray-500">${t.category_name||'-'}</td><td class="px-5 py-3"><span class="badge text-white" style="background:${t.status_color}">${t.status_name}</span></td><td class="px-5 py-3 capitalize text-gray-600">${t.priority}</td><td class="px-5 py-3 text-gray-500">${t.agent_name||'Sin asignar'}</td><td class="px-5 py-3 text-gray-500">${ago(t.created_at)}</td></tr>`).join(''):'<tr><td colspan="7" class="px-5 py-10 text-center text-gray-400">No hay tickets</td></tr>'}</tbody></table></div>
    </div>`;
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

// ═══ TICKET DETAIL ═══
async function pgTicketDetail(id){
  app().innerHTML=layout('Ticket #'+id,loading,'tickets');
  try{
    const[t,sts,ags]=await Promise.all([GET(`/api/tickets/${id}`),GET('/api/admin/statuses'),GET('/api/admin/agents')]);
    const u=getUser(),isAg=['admin','agent'].includes(u.role);
    let aiInfo='';try{const ai=t.ai_summary?JSON.parse(t.ai_summary):null;if(ai?.summary)aiInfo=`<div class="mt-4 p-3 bg-purple-50 dark:bg-purple-900/20 rounded-lg border border-purple-200 dark:border-purple-800"><p class="text-xs text-purple-600 font-medium mb-1"><i class="fas fa-robot mr-1"></i>Análisis IA</p><p class="text-sm text-purple-800 dark:text-purple-300">${ai.summary}</p></div>`}catch{}
    main().innerHTML=`<div class="space-y-6">
      <div class="flex items-center gap-3 flex-wrap"><a href="#tickets" class="text-gray-400 hover:text-gray-600"><i class="fas fa-arrow-left"></i></a><h2 class="text-xl font-bold dark:text-white">${t.subject}</h2><span class="badge text-white" style="background:${t.status_color}">${t.status_name}</span></div>
      <div class="grid lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 space-y-4">
          <div class="card p-5"><div class="text-gray-700 dark:text-gray-300 whitespace-pre-wrap">${t.description}</div>${aiInfo}${t.attachments?.length?`<div class="mt-4 flex flex-wrap gap-2">${t.attachments.map(a=>`<a href="/uploads/${a.filename}" target="_blank" class="inline-flex items-center gap-1 px-3 py-1.5 bg-gray-100 dark:bg-gray-700 rounded-lg text-xs hover:bg-gray-200"><i class="fas fa-paperclip"></i>${a.original_name}</a>`).join('')}</div>`:''}</div>
          <div class="card"><div class="p-5 border-b border-gray-200 dark:border-gray-700"><h3 class="font-semibold dark:text-white">Conversación (${t.comments?.length||0})</h3></div>
          <div class="divide-y divide-gray-100 dark:divide-gray-700">${t.comments?.length?t.comments.map(c=>`<div class="p-5 ${c.is_internal?'bg-yellow-50 dark:bg-yellow-900/10':''}"><div class="flex justify-between mb-2"><span class="font-medium text-sm dark:text-white">${c.user_name} <span class="text-xs text-gray-400 capitalize">(${c.user_role})</span>${c.is_internal?' <span class="text-xs text-yellow-600">🔒</span>':''}</span><span class="text-xs text-gray-400">${fmtDate(c.created_at)}</span></div><p class="text-sm text-gray-700 dark:text-gray-300 whitespace-pre-wrap">${c.comment}</p></div>`).join(''):'<p class="p-5 text-gray-400 text-sm">Sin comentarios</p>'}</div>
          ${!t.is_closed?`<div class="p-5 border-t border-gray-200 dark:border-gray-700"><form id="cf"><textarea id="ct" rows="3" required class="input-field" placeholder="Escribe un comentario..."></textarea><div class="flex justify-between items-center mt-3">${isAg?'<label class="flex items-center gap-2 text-sm text-gray-500"><input type="checkbox" id="ci"><span>Nota interna</span></label>':'<div></div>'}<button type="submit" class="btn-primary"><i class="fas fa-paper-plane mr-1"></i>Enviar</button></div></form></div>`:''}</div>
          ${isAg?'<button id="aiBtn" class="btn-primary bg-purple-600 hover:bg-purple-700" style="background:linear-gradient(135deg,#7c3aed,#9333ea)"><i class="fas fa-robot mr-1"></i>Sugerir respuesta IA</button>':''}
        </div>
        <div class="space-y-4">
          ${isAg?`<div class="card p-5 space-y-4"><h3 class="font-semibold dark:text-white">Gestionar</h3><form id="uf" class="space-y-3">
            <div><label class="text-xs text-gray-500">Estado</label><select id="us" class="input-field">${sts.map(s=>`<option value="${s.id}"${s.id===t.status_id?' selected':''}>${s.name}</option>`).join('')}</select></div>
            <div><label class="text-xs text-gray-500">Prioridad</label><select id="up" class="input-field">${['low','medium','high','critical'].map(p=>`<option value="${p}"${p===t.priority?' selected':''}>${p}</option>`).join('')}</select></div>
            <div><label class="text-xs text-gray-500">Asignado a</label><select id="ua" class="input-field"><option value="">Sin asignar</option>${ags.map(a=>`<option value="${a.id}"${a.id===t.assigned_to?' selected':''}>${a.name}</option>`).join('')}</select></div>
            <button type="submit" class="btn-primary w-full justify-center">Actualizar</button></form></div>`:``}
          <div class="card p-5 space-y-3 text-sm"><h3 class="font-semibold dark:text-white">Detalles</h3>
            <div class="flex justify-between"><span class="text-gray-500">Creado por</span><span class="dark:text-white">${t.creator_name}</span></div>
            <div class="flex justify-between"><span class="text-gray-500">Categoría</span><span class="dark:text-white">${t.category_name||'-'}</span></div>
            <div class="flex justify-between"><span class="text-gray-500">Activo</span><span class="dark:text-white">${t.asset_name||'-'}</span></div>
            <div class="flex justify-between"><span class="text-gray-500">SLA Resolución</span><span class="${t.sla_resolution_due&&new Date(t.sla_resolution_due)<new Date()&&!t.is_closed?'text-red-600 font-bold':'dark:text-white'}">${fmtDate(t.sla_resolution_due)}</span></div>
            <div class="flex justify-between"><span class="text-gray-500">Creado</span><span class="dark:text-white">${fmtDate(t.created_at)}</span></div>
            ${t.resolved_at?`<div class="flex justify-between"><span class="text-gray-500">Resuelto</span><span class="dark:text-white">${fmtDate(t.resolved_at)}</span></div>`:''}
          </div>
        </div>
      </div></div>`;
    $('cf')?.addEventListener('submit',async e=>{e.preventDefault();await POST(`/api/tickets/${id}/comments`,{comment:$('ct').value,is_internal:$('ci')?.checked||false});pgTicketDetail(id)});
    $('uf')?.addEventListener('submit',async e=>{e.preventDefault();await PUT(`/api/tickets/${id}`,{status_id:+$('us').value,priority:$('up').value,assigned_to:$('ua').value?+$('ua').value:null});pgTicketDetail(id)});
    $('aiBtn')?.addEventListener('click',async()=>{const b=$('aiBtn');b.innerHTML='<i class="fas fa-spinner fa-spin mr-1"></i>Pensando...';const r=await GET(`/api/tickets/${id}/ai-suggest`);if($('ct'))$('ct').value=r.suggestion;b.innerHTML='<i class="fas fa-robot mr-1"></i>Sugerir respuesta IA'});
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

// ═══ NEW TICKET ═══
async function pgNewTicket(){
  app().innerHTML=layout('Nuevo Ticket',loading,'tickets');
  const u=getUser(),isAg=['admin','agent'].includes(u.role);
  const[cats,ags]=await Promise.all([GET('/api/admin/categories'),GET('/api/admin/agents')]);
  let assets=[];if(isAg)try{assets=await GET('/api/assets')}catch{}
  const pCats=cats.filter(c=>!c.parent_id),sCats=cats.filter(c=>c.parent_id);
  main().innerHTML=`<div class="max-w-2xl mx-auto"><div class="card p-6"><h2 class="text-xl font-bold dark:text-white mb-6">Crear Ticket</h2>
    <form id="tf" class="space-y-5">
      <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Asunto *</label><input id="ns" required class="input-field"></div>
      <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Descripción *</label><textarea id="nd" rows="4" required class="input-field"></textarea></div>
      <div class="grid grid-cols-2 gap-4">
        <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Prioridad</label><select id="np" class="input-field"><option value="low">Baja</option><option value="medium" selected>Media</option><option value="high">Alta</option><option value="critical">Crítica</option></select></div>
        <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Categoría</label><select id="nc" class="input-field"><option value="">Seleccionar</option>${pCats.map(c=>`<option value="${c.id}">${c.name}</option>`).join('')}</select></div>
      </div>
      <div class="grid grid-cols-2 gap-4">
        <div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Subcategoría</label><select id="nsc" class="input-field"><option value="">Seleccionar</option></select></div>
        ${isAg?`<div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Asignar a</label><select id="na" class="input-field"><option value="">Sin asignar</option>${ags.map(a=>`<option value="${a.id}">${a.name}</option>`).join('')}</select></div>`:'<div></div>'}
      </div>
      ${assets.length?`<div><label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Activo</label><select id="nast" class="input-field"><option value="">Ninguno</option>${assets.map(a=>`<option value="${a.id}">${a.name} (${a.asset_tag})</option>`).join('')}</select></div>`:''}
      <button type="submit" class="btn-primary w-full justify-center"><i class="fas fa-paper-plane mr-2"></i>Crear Ticket</button>
    </form></div></div>`;
  $('nc').addEventListener('change',()=>{const pid=+$('nc').value;$('nsc').innerHTML='<option value="">Seleccionar</option>'+sCats.filter(c=>c.parent_id===pid).map(c=>`<option value="${c.id}">${c.name}</option>`).join('')});
  $('tf').addEventListener('submit',async e=>{e.preventDefault();const r=await POST('/api/tickets',{subject:$('ns').value,description:$('nd').value,priority:$('np').value,category_id:$('nc').value||null,subcategory_id:$('nsc').value||null,assigned_to:$('na')?.value||null,asset_id:$('nast')?.value||null});if(r.id)location.hash=`#tickets/${r.id}`});
}

// ═══ ASSETS ═══
async function pgAssets(param){
  if(param&&!isNaN(param))return pgAssetDetail(param);
  app().innerHTML=layout('Inventario',loading,'assets');
  try{
    const d=await GET('/api/assets');
    main().innerHTML=`<div class="space-y-4">
      <div class="flex justify-between items-center"><h2 class="text-xl font-bold dark:text-white">${d.length} activos</h2><button id="newAssetBtn" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nuevo Activo</button></div>
      <div class="card overflow-x-auto"><table class="w-full text-sm"><thead class="bg-gray-50 dark:bg-gray-700/50"><tr><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Tag</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Nombre</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Tipo</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Estado</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Asignado</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Tickets</th></tr></thead>
      <tbody class="divide-y divide-gray-100 dark:divide-gray-700">${d.length?d.map(a=>`<tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30 cursor-pointer" onclick="location.hash='#assets/${a.id}'"><td class="px-5 py-3 font-mono text-xs text-[#007A33]">${a.asset_tag}</td><td class="px-5 py-3 dark:text-gray-200">${a.name}</td><td class="px-5 py-3 capitalize text-gray-500">${a.type}</td><td class="px-5 py-3 capitalize text-gray-500">${a.status}</td><td class="px-5 py-3 text-gray-500">${a.assigned_user||'-'}</td><td class="px-5 py-3 text-gray-500">${a.ticket_count}</td></tr>`).join(''):'<tr><td colspan="6" class="px-5 py-10 text-center text-gray-400">No hay activos</td></tr>'}</tbody></table></div>
    </div>`;
    // New asset modal would go here - keeping it simple with prompt for now
    $('newAssetBtn').onclick=()=>location.hash='#assets/new';
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

async function pgAssetDetail(id){
  if(id==='new'){
    app().innerHTML=layout('Nuevo Activo','',`assets`);
    const ags=await GET('/api/admin/agents');
    main().innerHTML=`<div class="max-w-2xl mx-auto"><div class="card p-6"><h2 class="text-xl font-bold dark:text-white mb-6">Nuevo Activo</h2>
      <form id="af" class="space-y-4">
        <div class="grid grid-cols-2 gap-4"><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Nombre *</label><input id="an" required class="input-field"></div><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Tipo</label><select id="at" class="input-field"><option value="desktop">Desktop</option><option value="laptop">Laptop</option><option value="server">Servidor</option><option value="printer">Impresora</option><option value="network">Red</option><option value="phone">Teléfono</option><option value="software">Software</option><option value="other">Otro</option></select></div></div>
        <div class="grid grid-cols-2 gap-4"><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Marca</label><input id="ab" class="input-field"></div><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Modelo</label><input id="am" class="input-field"></div></div>
        <div class="grid grid-cols-2 gap-4"><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Serial</label><input id="as" class="input-field"></div><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Ubicación</label><input id="al" class="input-field"></div></div>
        <div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Asignado a</label><select id="aa" class="input-field"><option value="">Nadie</option>${ags.map(a=>`<option value="${a.id}">${a.name}</option>`).join('')}</select></div>
        <div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Notas</label><textarea id="ano" rows="2" class="input-field"></textarea></div>
        <button type="submit" class="btn-primary w-full justify-center">Crear Activo</button></form></div></div>`;
    $('af').onsubmit=async e=>{e.preventDefault();const r=await POST('/api/assets',{name:$('an').value,type:$('at').value,brand:$('ab').value,model:$('am').value,serial_number:$('as').value,location:$('al').value,assigned_to:$('aa').value||null,notes:$('ano').value});if(r.id)location.hash='#assets'};
    return;
  }
  app().innerHTML=layout('Activo',loading,'assets');
  try{
    const a=await GET(`/api/assets/${id}`);
    main().innerHTML=`<div class="space-y-6">
      <div class="flex items-center gap-3"><a href="#assets" class="text-gray-400 hover:text-gray-600"><i class="fas fa-arrow-left"></i></a><h2 class="text-xl font-bold dark:text-white">${a.name}</h2><span class="badge bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300">${a.asset_tag}</span></div>
      <div class="grid lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 space-y-4">
          <div class="card p-5 grid grid-cols-2 gap-4 text-sm">${[['Tipo',a.type],['Marca',a.brand],['Modelo',a.model],['Serial',a.serial_number],['Ubicación',a.location],['IP',a.ip_address],['Estado',a.status],['Asignado',a.assigned_user],['Compra',fmtDate(a.purchase_date)],['Garantía',fmtDate(a.warranty_until)]].map(([k,v])=>`<div><span class="text-gray-500 block">${k}</span><span class="dark:text-white font-medium">${v||'-'}</span></div>`).join('')}</div>
          <div class="card"><div class="p-5 border-b border-gray-200 dark:border-gray-700"><h3 class="font-semibold dark:text-white">Mantenimientos (${a.maintenance?.length||0})</h3></div>
          <div class="divide-y divide-gray-100 dark:divide-gray-700">${a.maintenance?.length?a.maintenance.map(m=>`<div class="p-4 text-sm"><div class="flex justify-between mb-1"><span class="font-medium dark:text-white capitalize">${m.type}</span><span class="text-gray-400">${fmtDate(m.performed_at)}</span></div><p class="text-gray-600 dark:text-gray-300">${m.description}</p>${m.cost?`<p class="text-xs text-gray-400 mt-1">Costo: $${m.cost}</p>`:''}</div>`).join(''):'<p class="p-5 text-gray-400 text-sm">Sin registros</p>'}</div></div>
        </div>
        <div class="space-y-4">
          <div class="card p-5"><h3 class="font-semibold dark:text-white mb-3">Tickets Relacionados</h3>${a.tickets?.length?a.tickets.map(t=>`<a href="#tickets/${t.id}" class="block p-2 hover:bg-gray-50 dark:hover:bg-gray-700/30 rounded text-sm"><span class="text-[#007A33] font-medium">#${t.id}</span> ${t.subject}</a>`).join(''):'<p class="text-gray-400 text-sm">Ninguno</p>'}</div>
        </div>
      </div></div>`;
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

// ═══ KNOWLEDGE BASE ═══
async function pgKB(param){
  if(param&&!isNaN(param))return pgKBDetail(param);
  app().innerHTML=layout('Base de Conocimiento',loading,'knowledge');
  try{
    const d=await GET('/api/knowledge');const u=getUser();const isAg=['admin','agent'].includes(u.role);
    main().innerHTML=`<div class="space-y-4">
      <div class="flex justify-between items-center"><h2 class="text-xl font-bold dark:text-white">${d.length} artículos</h2>${isAg?'<a href="#knowledge/new" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nuevo</a>':''}</div>
      <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-4">${d.map(a=>`<div class="card p-5 hover:shadow-md transition-shadow cursor-pointer" onclick="location.hash='#knowledge/${a.id}'"><div class="flex items-center gap-2 mb-2">${a.is_pinned?'<i class="fas fa-thumbtack text-yellow-500"></i>':''}<span class="text-xs text-gray-400"><i class="fas ${a.category_icon||'fa-folder'} mr-1"></i>${a.category_name||'Sin categoría'}</span></div><h3 class="font-semibold dark:text-white mb-2">${a.title}</h3><div class="flex justify-between text-xs text-gray-400"><span><i class="fas fa-eye mr-1"></i>${a.views}</span><span>${ago(a.updated_at)}</span></div></div>`).join('')}</div>
    </div>`;
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

async function pgKBDetail(id){
  if(id==='new'){
    app().innerHTML=layout('Nuevo Artículo','','knowledge');
    const cats=await GET('/api/knowledge/categories');
    main().innerHTML=`<div class="max-w-3xl mx-auto"><div class="card p-6"><h2 class="text-xl font-bold dark:text-white mb-6">Nuevo Artículo</h2>
      <form id="kf" class="space-y-4"><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Título *</label><input id="kt" required class="input-field"></div>
      <div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Contenido *</label><textarea id="kc" rows="10" required class="input-field"></textarea></div>
      <div class="grid grid-cols-2 gap-4"><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Categoría</label><select id="kcat" class="input-field"><option value="">Ninguna</option>${cats.map(c=>`<option value="${c.id}">${c.name}</option>`).join('')}</select></div><div><label class="block text-sm font-medium dark:text-gray-300 mb-1">Estado</label><select id="ks" class="input-field"><option value="draft">Borrador</option><option value="published">Publicado</option></select></div></div>
      <button type="submit" class="btn-primary w-full justify-center">Guardar</button></form></div></div>`;
    $('kf').onsubmit=async e=>{e.preventDefault();const r=await POST('/api/knowledge',{title:$('kt').value,content:$('kc').value,category_id:$('kcat').value||null,status:$('ks').value});if(r.id)location.hash='#knowledge'};
    return;
  }
  app().innerHTML=layout('Artículo',loading,'knowledge');
  try{
    const a=await GET(`/api/knowledge/${id}`);
    main().innerHTML=`<div class="max-w-3xl mx-auto space-y-4">
      <a href="#knowledge" class="text-gray-400 hover:text-gray-600 text-sm"><i class="fas fa-arrow-left mr-1"></i>Volver</a>
      <div class="card p-6"><div class="mb-4"><span class="text-xs text-gray-400"><i class="fas fa-folder mr-1"></i>${a.category_name||'Sin categoría'}</span><span class="text-xs text-gray-400 ml-4"><i class="fas fa-eye mr-1"></i>${a.views} vistas</span><span class="text-xs text-gray-400 ml-4">${fmtDate(a.updated_at)}</span></div>
      <h1 class="text-2xl font-bold dark:text-white mb-4">${a.title}</h1>
      <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">${a.content}</div></div>
    </div>`;
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

// ═══ USERS ═══
async function pgUsers(){
  app().innerHTML=layout('Usuarios',loading,'users');
  try{
    const d=await GET('/api/admin/users');
    main().innerHTML=`<div class="space-y-4">
      <div class="flex justify-between items-center"><h2 class="text-xl font-bold dark:text-white">${d.length} usuarios</h2><button id="nuBtn" class="btn-primary"><i class="fas fa-plus mr-2"></i>Nuevo</button></div>
      <div class="card overflow-x-auto"><table class="w-full text-sm"><thead class="bg-gray-50 dark:bg-gray-700/50"><tr><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Nombre</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Email</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Rol</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Estado</th><th class="text-left px-5 py-3 text-xs text-gray-500 uppercase">Último Login</th></tr></thead>
      <tbody class="divide-y divide-gray-100 dark:divide-gray-700">${d.map(u=>`<tr class="hover:bg-gray-50 dark:hover:bg-gray-700/30"><td class="px-5 py-3 font-medium dark:text-white">${u.name}</td><td class="px-5 py-3 text-gray-500">${u.email}</td><td class="px-5 py-3 capitalize text-gray-500">${u.role}</td><td class="px-5 py-3"><span class="badge ${u.active?'bg-green-100 text-green-800':'bg-red-100 text-red-800'}">${u.active?'Activo':'Inactivo'}</span></td><td class="px-5 py-3 text-gray-500">${u.last_login?ago(u.last_login):'-'}</td></tr>`).join('')}</tbody></table></div>
    </div>`;
    $('nuBtn').onclick=()=>{
      const n=prompt('Nombre:'),e=prompt('Email:'),p=prompt('Contraseña:'),r=prompt('Rol (admin/agent/client):','client');
      if(n&&e&&p)POST('/api/admin/users',{name:n,email:e,password:p,role:r||'client'}).then(()=>pgUsers());
    };
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

// ═══ SETTINGS ═══
async function pgSettings(){
  app().innerHTML=layout('Configuración',loading,'settings');
  try{
    const[s,sts,sla]=await Promise.all([GET('/api/admin/settings'),GET('/api/admin/statuses'),GET('/api/admin/sla')]);
    main().innerHTML=`<div class="space-y-6">
      <div class="card p-5"><h3 class="font-semibold dark:text-white mb-4">General</h3><form id="sf" class="space-y-3">
        <div class="grid grid-cols-2 gap-4"><div><label class="text-sm text-gray-500">Nombre App</label><input id="sn" class="input-field" value="${s.app_name||''}"></div><div><label class="text-sm text-gray-500">Empresa</label><input id="sc" class="input-field" value="${s.company_name||''}"></div></div>
        <div><label class="text-sm text-gray-500">API Key Gemini (IA)</label><input id="sk" type="password" class="input-field" value="${s.gemini_api_key||''}" placeholder="Dejar vacío para desactivar IA"></div>
        <button type="submit" class="btn-primary">Guardar</button></form></div>
      <div class="card p-5"><h3 class="font-semibold dark:text-white mb-4">Estados de Ticket</h3><div class="flex flex-wrap gap-2">${sts.map(s=>`<span class="badge text-white" style="background:${s.color}"><i class="fas ${s.icon} mr-1"></i>${s.name}${s.is_closed?' (cierre)':''}</span>`).join('')}</div></div>
      <div class="card p-5"><h3 class="font-semibold dark:text-white mb-4">Políticas SLA</h3><table class="w-full text-sm"><thead><tr><th class="text-left py-2 text-gray-500">Nombre</th><th class="text-left py-2 text-gray-500">Prioridad</th><th class="text-left py-2 text-gray-500">Respuesta</th><th class="text-left py-2 text-gray-500">Resolución</th></tr></thead><tbody>${sla.map(p=>`<tr><td class="py-2 dark:text-white">${p.name}</td><td class="py-2 capitalize text-gray-500">${p.priority}</td><td class="py-2 text-gray-500">${p.response_hours}h</td><td class="py-2 text-gray-500">${p.resolution_hours}h</td></tr>`).join('')}</tbody></table></div>
    </div>`;
    $('sf').onsubmit=async e=>{e.preventDefault();await PUT('/api/admin/settings',{app_name:$('sn').value,company_name:$('sc').value,gemini_api_key:$('sk').value});alert('Configuración guardada')};
  }catch(e){main().innerHTML=`<p class="text-red-500 p-8">Error: ${e.message}</p>`}
}

function pg404(){app().innerHTML=layout('404','<div class="text-center py-20"><h2 class="text-2xl font-bold text-gray-400">Página no encontrada</h2><a href="#dashboard" class="text-[#007A33] hover:underline mt-4 inline-block">Ir al Dashboard</a></div>')}
