const mysql = require('mysql2/promise');
require('dotenv').config(); // 🔥 Línea clave: asegura que lea tu archivo .env

const pool = mysql.createPool({
  host: process.env.DB_HOST || 'localhost',
  user: process.env.DB_USER,      // ❌ Quitamos 'root' para evitar bloqueos
  password: process.env.DB_PASSWORD, 
  database: process.env.DB_NAME,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0
});

// Verificación de conexión para el log
pool.getConnection()
  .then(conn => {
    console.log('✅ Conexión a la base de datos establecida correctamente');
    conn.release();
  })
  .catch(err => {
    console.error('❌ Error crítico de conexión a la DB:', err.message);
  });

module.exports = pool;