// backend/config/nodemailer-patch.js
const path = require('path');
const fs = require('fs');

// Asegura .env temprano
(() => {
  const p = path.resolve(__dirname, '../.env');
  if (fs.existsSync(p)) require('dotenv').config({ path: p });
})();

const nodemailer = require('nodemailer');
const original = nodemailer.createTransport;

nodemailer.createTransport = function patchedCreateTransport(opts, ...rest) {
  const noAuth =
    !opts ||
    !opts.auth ||
    !opts.auth.user ||
    !opts.auth.pass;

  if (noAuth) {
    const e = new Error('Transport SIN auth');
    console.error('🚨 nodemailer.createTransport sin auth detectado. Llamado desde:\n' + e.stack);
    console.error('🧩 Opciones recibidas:', JSON.stringify(opts || {}, null, 2));
  }
  return original.call(this, opts, ...rest);
};

module.exports = nodemailer;
