const pool = require('../config/db');

// Crear caso de soporte
async function crearSoporte(req, res) {
    try {
      const { titulo, descripcion, fecha_descubrimiento, funcionario, oficina, tipo_evento } = req.body;
      const usuarioId = req.user.sub;
  
      if (!titulo || !descripcion || !fecha_descubrimiento || !funcionario || !oficina || !tipo_evento) {
        return res.status(400).json({ message: 'Todos los campos son obligatorios' });
      }
  
      const [result] = await pool.query(
        `INSERT INTO reportes_soporte 
         (usuario_id, titulo, descripcion, fecha_descubrimiento, funcionario, oficina, tipo_evento) 
         VALUES (?, ?, ?, ?, ?, ?, ?)`,
        [usuarioId, titulo, descripcion, fecha_descubrimiento, funcionario, oficina, tipo_evento]
      );
  
      res.json({
        id: result.insertId,
        titulo,
        descripcion,
        fecha_descubrimiento,
        funcionario,
        oficina,
        tipo_evento,
        estado: 'pendiente'
      });
    } catch (err) {
      console.error(err);
      res.status(500).json({ message: 'Error al registrar el soporte' });
    }
  }
  

// Listar soportes del usuario autenticado
async function listarSoportesUsuario(req, res) {
  try {
    const usuarioId = req.user.sub;
    const [rows] = await pool.query(
      'SELECT * FROM reportes_soporte WHERE usuario_id = ? ORDER BY fecha_creacion DESC',
      [usuarioId]
    );
    res.json(rows);
  } catch (err) {
    console.error(err);
    res.status(500).json({ message: 'Error al obtener soportes' });
  }
}

module.exports = { crearSoporte, listarSoportesUsuario };
