// backend/routes/conocimiento.routes.js
const express = require('express');
const pool = require('../config/db');
const { authRequired } = require('../middlewares/auth');

module.exports = (JWT_SECRET) => {
  const router = express.Router();

  // 🔍 BUSCAR soluciones (Para todos)
  router.get('/buscar', authRequired(JWT_SECRET), async (req, res) => {
    try {
      const { q } = req.query; // Palabra clave (ej: "impresora")
      const queryStr = `%${q || ''}%`;
      
      const [rows] = await pool.query(
        `SELECT id, titulo, categoria, vistas 
         FROM base_conocimiento 
         WHERE titulo LIKE ? OR contenido LIKE ? 
         ORDER BY vistas DESC`, 
        [queryStr, queryStr]
      );
      res.json(rows);
    } catch (err) {
      res.status(500).json({ message: "Error al buscar soluciones" });
    }
  });

  // 📖 VER una solución completa (y sumar una vista)
  router.get('/:id', authRequired(JWT_SECRET), async (req, res) => {
    try {
      const { id } = req.params;
      await pool.query('UPDATE base_conocimiento SET vistas = vistas + 1 WHERE id = ?', [id]);
      const [rows] = await pool.query('SELECT * FROM base_conocimiento WHERE id = ?', [id]);
      res.json(rows[0]);
    } catch (err) {
      res.status(500).json({ message: "Error al cargar la solución" });
    }
  });

  // ✍️ CREAR solución (Solo ADMIN)
  router.post('/', authRequired(JWT_SECRET), async (req, res) => {
    if (req.user.rol !== 'admin') return res.status(403).json({ message: "No autorizado" });
    const { titulo, categoria, contenido } = req.body;
    try {
      await pool.query(
        'INSERT INTO base_conocimiento (titulo, categoria, contenido) VALUES (?, ?, ?)',
        [titulo, categoria, contenido]
      );
      res.json({ message: "✅ Solución guardada con éxito" });
    } catch (err) {
      res.status(500).json({ message: "Error al guardar" });
    }
  });

  return router;
};