const express = require("express");
const fs = require("fs");
const path = require("path");

module.exports = (JWT_SECRET) => {
  const router = express.Router();
  const dataPath = path.join(__dirname, "../data/helpdesk.json");

  // Buscar soluciones
  router.get("/", (req, res) => {
    const query = (req.query.query || "").toLowerCase();
    if (!query) {
      return res.status(400).json({ message: "Debes enviar una consulta" });
    }

    try {
      const data = JSON.parse(fs.readFileSync(dataPath, "utf-8"));
      const results = data.filter(item =>
        item.problema.toLowerCase().includes(query) ||
        item.palabras_clave.some(k => k.toLowerCase().includes(query))
      );
      res.json(results);
    } catch (error) {
      console.error(error);
      res.status(500).json({ message: "Error leyendo base de conocimiento" });
    }
  });

  // Recomendaciones dinámicas
  router.get("/recommendations", (req, res) => {
    const query = (req.query.query || "").toLowerCase();

    try {
      const data = JSON.parse(fs.readFileSync(dataPath, "utf-8"));

      // Filtrar por problemas que contengan alguna coincidencia parcial
      const recommendations = data.filter(item =>
        item.problema.toLowerCase().includes(query) ||
        item.palabras_clave.some(k => k.toLowerCase().includes(query))
      );

      // Si no hay coincidencias, sugerimos los 3 primeros
      const finalRecs = recommendations.length > 0
        ? recommendations.slice(0, 3)
        : data.slice(0, 3);

      res.json(finalRecs);
    } catch (error) {
      console.error(error);
      res.status(500).json({ message: "Error generando recomendaciones" });
    }
  });

  return router;
};
