const express = require('express');
const router = express.Router();
const pool = require('../config/db'); // tu conexión a la BD
const { authRequired } = require('../middlewares/auth');

router.get('/', authRequired(process.env.JWT_SECRET), async (req, res) => {
  try {
    const userId = req.user.sub;

    // Tomamos solo reportes "En proceso" del usuario
    const [rows] = await pool.query(
      'SELECT tipo_evento, detalle FROM reportes_soporte WHERE funcionario = ? AND estado = "En proceso"',
      [req.user.nombre]
    );

    if (rows.length === 0) {
      return res.json([]);
    }

    // Aquí puedes mapear los tipos de evento a soluciones predefinidas
    const knowledge = {
      "Fallas en telecomunicaciones": "Verifique que el router esté encendido, reinícielo y confirme que los cables estén conectados. Si persiste, contacte a su proveedor de internet.",
      "Problemas en hardware": "Revise que los cables y periféricos estén conectados correctamente, pruebe con otro puerto USB y asegúrese de que los controladores estén actualizados.",
      "Problemas en software": "Compruebe la configuración de audio y video en la aplicación, cierre otros programas que usen cámara/micrófono y reinstale si el problema continúa.",
      "Errores en impresión": "Verifique que la impresora tenga papel y tinta, limpie los rodillos, reinicie la cola de impresión y asegúrese de que esté instalada como predeterminada.",
      "Fallas en correo electrónico": "Revise la conexión a internet, confirme las credenciales, elimine correos antiguos si el buzón está lleno y pruebe desde otro dispositivo.",
      "Sistema operativo lento": "Revise el uso de memoria en el administrador de tareas, elimine programas innecesarios al inicio y ejecute un análisis antivirus."
    };

    const recomendaciones = rows.map(r => ({
      problema: r.tipo_evento,
      solucion: knowledge[r.tipo_evento] || "No hay solución registrada aún."
    }));

    res.json(recomendaciones);

  } catch (err) {
    console.error("Error en recomendaciones:", err);
    res.status(500).json({ message: "Error en recomendaciones" });
  }
});

module.exports = router;
