const { Router } = require('express');
const { crearSoporte, listarSoportesUsuario } = require('../controllers/soporte.controller');
const { authRequired } = require('../middlewares/auth');

const router = Router();

module.exports = (JWT_SECRET) => {
  router.post('/', authRequired(JWT_SECRET), crearSoporte);
  router.get('/', authRequired(JWT_SECRET), listarSoportesUsuario);
  return router;
};
