const express = require('express');
const router = express.Router();
const pool = require('../config/db');
const { authRequired } = require('../middlewares/auth');

module.exports = (JWT_SECRET) => {
  // 1. Listar todos los usuarios
  router.get('/', authRequired(JWT_SECRET), async (req, res) => {
    try {
      const [rows] = await pool.query('SELECT id, nombre, tipo, activo FROM usuarios');
      res.json(rows);
    } catch (err) {
      res.status(500).json({ message: err.message });
    }
  });

 // 2. Crear un nuevo usuario (CORREGIDO con email automático)
  router.post('/', authRequired(JWT_SECRET), async (req, res) => {
    const { nombre, password, tipo } = req.body;
    
    // Generamos un correo ficticio para que la DB no de error
    // Ejemplo: "Ximena Test" -> "ximena.test@fedef.com"
    const emailAutomatico = `${nombre.toLowerCase().replace(/\s+/g, '.')}@fedef.com`;

    try {
      // ✅ Añadimos 'email' a la consulta SQL
      await pool.query(
        'INSERT INTO usuarios (nombre, password, tipo, activo, email) VALUES (?, ?, ?, 1, ?)', 
        [nombre, password, tipo, emailAutomatico]
      );
      res.json({ message: 'Usuario creado con éxito' });
    } catch (err) {
      console.error("Error en DB:", err);
      res.status(500).json({ message: err.message });
    }
  });

  // 3. Cambiar estado (Activar/Desactivar) o Editar
  router.put('/:id', authRequired(JWT_SECRET), async (req, res) => {
    const { id } = req.params;
    const { activo, tipo, password } = req.body;
    try {
      // Actualización dinámica según lo que envíes
      if (password) {
        await pool.query('UPDATE usuarios SET password = ? WHERE id = ?', [password, id]);
      } else if (tipo) {
        await pool.query('UPDATE usuarios SET tipo = ? WHERE id = ?', [tipo, id]);
      } else {
        await pool.query('UPDATE usuarios SET activo = ? WHERE id = ?', [activo, id]);
      }
      res.json({ message: 'Usuario actualizado' });
    } catch (err) {
      res.status(500).json({ message: err.message });
    }
  });

  return router;
};