<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel Admin - FEDEF</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8 font-sans">
    <div class="max-w-4xl mx-auto bg-white p-10 rounded-3xl shadow-xl">
        <h2 class="text-2xl font-black mb-8 border-b pb-4 text-slate-800">Administración de Usuarios y Agentes</h2>

        <section class="mb-10">
            <h3 class="text-blue-600 font-bold mb-4 uppercase text-xs">Crear Nuevo Agente o Cliente</h3>
            <form action="procesar_admin.php" method="POST" class="grid grid-cols-2 gap-4">
                <input type="hidden" name="accion" value="crear_usuario">
                <input type="text" name="nombre" placeholder="Nombre Completo" class="p-3 border rounded-xl" required>
                <input type="email" name="email" placeholder="Email" class="p-3 border rounded-xl" required>
                <input type="password" name="password" placeholder="Contraseña" class="p-3 border rounded-xl" required>
                <select name="rol" class="p-3 border rounded-xl bg-white">
                    <option value="2">Rol: Agente</option>
                    <option value="3">Rol: Cliente</option>
                </select>
                <button type="submit" class="col-span-2 bg-green-600 text-white py-3 rounded-xl font-bold hover:bg-green-700 transition">GUARDAR USUARIO</button>
            </form>
        </section>

        <section>
            <h3 class="text-blue-600 font-bold mb-4 uppercase text-xs">Reasignar a otros Agentes</h3>
            <table class="w-full text-left text-sm border">
                <thead class="bg-gray-50">
                    <tr><th class="p-3">Ticket</th><th class="p-3">Agente Actual</th><th class="p-3">Cambiar a:</th></tr>
                </thead>
                <tbody>
                    <?php
                    $res = $conn->query("SELECT t.id, t.code, u.name as agent_name FROM tickets t LEFT JOIN users u ON t.agent_id = u.id ORDER BY t.id DESC");
                    while($row = $res->fetch_assoc()): ?>
                    <tr class="border-b">
                        <td class="p-3 font-bold"><?php echo $row['code']; ?></td>
                        <td class="p-3 italic"><?php echo $row['agent_name'] ?? 'Pendiente'; ?></td>
                        <td class="p-3">
                            <form action="procesar_admin.php" method="POST">
                                <input type="hidden" name="accion" value="reasignar">
                                <input type="hidden" name="ticket_id" value="<?php echo $row['id']; ?>">
                                <select name="nuevo_agente" onchange="this.form.submit()" class="p-1 border rounded">
                                    <option value="">Seleccionar Agente...</option>
                                    <?php
                                    $ags = $conn->query("SELECT id, name FROM users WHERE role_id = 2");
                                    while($a = $ags->fetch_assoc()) echo "<option value='{$a['id']}'>{$a['name']}</option>";
                                    ?>
                                </select>
                            </form>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </section>
        <div class="mt-6 text-center"><a href="dashboard.php" class="text-blue-500 underline">Volver al Panel Principal</a></div>
    </div>
</body>
</html>