<?php 
include 'db.php'; 
requiere_login();
$uid = $_SESSION['user_id'];
$alertas = $conn->query("SELECT * FROM tickets WHERE agent_id = $uid AND is_read_by_agent = 0");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>SolidDesk - Soporte</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-indigo-50/50 flex h-screen font-sans">

    <div class="w-64 bg-gradient-to-b from-slate-900 to-indigo-950 text-white p-6 shadow-2xl">
        <h1 class="text-3xl font-black mb-10 italic tracking-tighter">Solid<span class="text-indigo-400">Desk</span></h1>
        <nav class="space-y-3">
            <a href="dashboard.php" class="flex items-center gap-3 p-3 rounded-xl bg-indigo-600 shadow-lg shadow-indigo-900/50"><i class="fas fa-home"></i> Inicio</a>
            <a href="nuevo_ticket.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-white/10 transition"><i class="fas fa-plus"></i> Crear Ticket</a>
            <?php if($_SESSION['role'] == 1): ?>
                <a href="configuracion.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-white/10 text-yellow-400 transition"><i class="fas fa-user-cog"></i> Admin</a>
            <?php endif; ?>
        </nav>
    </div>

    <div class="flex-1 p-8 overflow-y-auto">
        <header class="flex justify-between items-center mb-8">
            <h2 class="text-2xl font-black text-slate-800 uppercase tracking-tight">Panel de Gestin</h2>
            
            <div class="relative group">
                <button class="bg-white p-4 rounded-2xl shadow-sm border border-indigo-100 hover:bg-indigo-50 transition">
                    <i class="fas fa-bell text-xl <?php echo $alertas->num_rows > 0 ? 'text-rose-500 animate-bounce' : 'text-slate-300'; ?>"></i>
                    <?php if($alertas->num_rows > 0): ?>
                        <span class="absolute top-3 right-3 bg-rose-600 text-white text-[10px] px-1.5 rounded-full border-2 border-white"><?php echo $alertas->num_rows; ?></span>
                    <?php endif; ?>
                </button>
                
                <div class="absolute right-0 mt-2 w-72 bg-white rounded-2xl shadow-2xl border border-indigo-50 hidden group-hover:block z-50 p-4">
                    <h4 class="text-[10px] font-black text-slate-400 uppercase mb-3">Tareas Pendientes</h4>
                    <?php if($alertas->num_rows > 0): while($al = $alertas->fetch_assoc()): ?>
                        <div class="p-2 hover:bg-indigo-50 rounded-lg mb-1 border-b last:border-0">
                            <p class="text-xs font-bold text-indigo-600"><?php echo $al['code']; ?></p>
                            <p class="text-[10px] text-slate-500 truncate"><?php echo $al['title']; ?></p>
                        </div>
                    <?php endwhile; else: ?>
                        <p class="text-center text-slate-400 py-4 text-xs italic">Sin notificaciones</p>
                    <?php endif; ?>
                </div>
            </div>
        </header>

        <div class="bg-white rounded-3xl shadow-xl shadow-indigo-100 overflow-hidden border border-indigo-50">
            <table class="w-full text-left">
                <thead class="bg-indigo-600 text-white">
                    <tr>
                        <th class="p-5 text-xs font-bold uppercase">Cdigo</th>
                        <th class="p-5 text-xs font-bold uppercase">Asunto</th>
                        <th class="p-5 text-xs font-bold uppercase">Agente</th>
                        <th class="p-5 text-xs font-bold uppercase">Estado</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-indigo-50">
                    <?php
                    $res = $conn->query("SELECT t.*, u.name as agente FROM tickets t LEFT JOIN users u ON t.agent_id = u.id ORDER BY t.id DESC");
                    while($row = $res->fetch_assoc()): ?>
                    <tr class="hover:bg-indigo-50/50 transition">
                        <td class="p-5 font-black text-indigo-600"><?php echo $row['code']; ?></td>
                        <td class="p-5 font-bold text-slate-700"><?php echo $row['title']; ?></td>
                        <td class="p-5 text-sm text-slate-500 italic"><?php echo $row['agente'] ?? 'Sin asignar'; ?></td>
                        <td class="p-5">
                            <span class="px-3 py-1 bg-amber-100 text-amber-700 rounded-lg text-[10px] font-black uppercase">Abierto</span>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>