<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>SolidDesk - Acceso</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 h-screen flex items-center justify-center p-4">
    <div class="bg-white p-10 rounded-[2.5rem] shadow-2xl w-full max-w-md border-t-8 border-indigo-600">
        <h1 class="text-4xl font-black text-center text-slate-800 mb-8 italic italic">Solid<span class="text-indigo-600">Desk</span></h1>
        
        <?php
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $email = trim($conn->real_escape_string($_POST['email']));
            $res = $conn->query("SELECT * FROM users WHERE email = '$email' LIMIT 1");
            if ($res && $res->num_rows > 0) {
                $u = $res->fetch_assoc();
                if (password_verify($_POST['password'], $u['password'])) {
                    $_SESSION['user_id'] = $u['id'];
                    $_SESSION['user_name'] = $u['name'];
                    $_SESSION['role'] = $u['role_id'];
                    header("Location: dashboard.php");
                    exit();
                }
            }
            echo "<p class='text-red-500 font-bold text-center mb-4 text-sm bg-red-50 p-3 rounded-xl'>Credenciales incorrectas</p>";
        }
        ?>

        <form method="POST" class="space-y-6">
            <input type="email" name="email" placeholder="admin@soliddesk.com" class="w-full p-4 bg-slate-100 rounded-2xl outline-none" required>
            <input type="password" name="password" placeholder="••••••••" class="w-full p-4 bg-slate-100 rounded-2xl outline-none" required>
            <button class="w-full bg-indigo-600 text-white py-4 rounded-2xl font-black hover:bg-indigo-700 shadow-lg transition transform active:scale-95">INGRESAR</button>
        </form>
        <div class="mt-6 text-center"><a href="recuperar.php" class="text-indigo-600 text-sm font-bold">¿Olvidaste tu contraseña?</a></div>
    </div>
</body>
</html>