<?php
include 'db.php';
$conn->query("SET FOREIGN_KEY_CHECKS = 0");

// Borramos absolutamente todo lo que pueda causar conflicto
$tablas = ['audit_logs', 'kb_articles', 'ticket_comments', 'tickets', 'users', 'assets', 'priorities', 'roles', 'statuses', 'categories'];
foreach ($tablas as $t) { $conn->query("DROP TABLE IF EXISTS $t"); }

// 1. Tabla de USUARIOS (Limpia)
$conn->query("CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role_id INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 2. Tabla de TICKETS (Con todas las columnas para que el Dashboard NO falle)
$conn->query("CREATE TABLE tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(20) UNIQUE,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    client_id INT,
    agent_id INT,
    status_id INT DEFAULT 1,
    is_read_by_agent TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 3. Crear el Administrador Maestro (Clave: Admin123*)
$pass_admin = password_hash("Admin123*", PASSWORD_BCRYPT);
$sql = "INSERT INTO users (name, email, password, role_id) VALUES ('Admin SolidDesk', 'admin@soliddesk.com', '$pass_admin', 1)";

if ($conn->query($sql)) {
    echo "<h1 style='color:green'>✅ REINICIO EXITOSO</h1>";
    echo "<p>Base de datos reconstruida. Prueba el login con <b>admin@soliddesk.com</b> / <b>Admin123*</b></p>";
    echo "<a href='login.php'>IR AL LOGIN</a>";
}
$conn->query("SET FOREIGN_KEY_CHECKS = 1");
?>