<?php include 'db.php'; $prioridades = $conn->query("SELECT * FROM priorities"); ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Nuevo Ticket - FEDEF</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
    <div class="max-w-xl mx-auto bg-white p-8 rounded-2xl shadow-lg">
        <h2 class="text-2xl font-bold mb-6 text-slate-800">Crear Requerimiento FEDEF</h2>
        <form action="procesar_ticket.php" method="POST" enctype="multipart/form-data" class="space-y-4">
            <input type="text" name="title" placeholder="Asunto" class="w-full p-3 border rounded" required>
            <textarea name="description" placeholder="Descripción del problema" class="w-full p-3 border rounded h-32" required></textarea>
            <select name="priority_id" class="w-full p-3 border rounded">
                <?php while($p = $prioridades->fetch_assoc()): ?>
                    <option value="<?php echo $p['id']; ?>"><?php echo $p['name']; ?></option>
                <?php endwhile; ?>
            </select>
            <div class="bg-blue-50 p-4 rounded border border-blue-200">
                <label class="block text-sm font-bold text-blue-700 mb-1">Notificar a (correos separados por coma):</label>
                <input type="text" name="notif_email" placeholder="ejemplo@fedef.com, jefe@fedef.com" class="w-full p-2 border rounded" required>
            </div>
            <div class="p-2 border-2 border-dashed rounded text-center">
                <input type="file" name="attachment" class="text-xs">
            </div>
            <button type="submit" class="w-full bg-blue-600 text-white py-3 rounded-xl font-bold text-lg hover:bg-blue-700">GUARDAR Y ENVIAR</button>
        </form>
    </div>
</body>
</html>