<?php
include 'db.php';

// 1. Forzamos la desactivación de llaves foráneas para evitar el error #3730
$conn->query("SET FOREIGN_KEY_CHECKS = 0");

// 2. Borramos las tablas conflictivas en el orden correcto
$tablas = ['audit_logs', 'kb_articles', 'ticket_comments', 'tickets', 'users', 'assets', 'priorities', 'roles', 'statuses', 'categories'];
foreach ($tablas as $t) {
    $conn->query("DROP TABLE IF EXISTS $t");
}

// 3. Recreamos la tabla de USUARIOS con la estructura que el login necesita
$conn->query("CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role_id INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 4. Recreamos la tabla de TICKETS con la columna que falta (is_read_by_agent)
$conn->query("CREATE TABLE tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(20) UNIQUE,
    title VARCHAR(255),
    agent_id INT,
    is_read_by_agent TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 5. Creamos el Administrador Maestro (Clave: Admin123*)
$hash = password_hash("Admin123*", PASSWORD_BCRYPT);
$sql = "INSERT INTO users (name, email, password, role_id) VALUES ('Administrador SolidDesk', 'admin@soliddesk.com', '$hash', 1)";

if ($conn->query($sql)) {
    echo "<h2 style='color:green; font-family:sans-serif;'>✅ ¡SISTEMA RECONSTRUIDO CON ÉXITO!</h2>";
    echo "<p>Los bloqueos de base de datos han sido eliminados.</p>";
    echo "<a href='login.php' style='padding:10px; background:blue; color:white; text-decoration:none; border-radius:5px;'>IR AL LOGIN</a>";
} else {
    echo "Error crítico: " . $conn->error;
}

$conn->query("SET FOREIGN_KEY_CHECKS = 1");
?>