<?php
include 'db.php';

// 1. Apagamos candados de seguridad a nivel de sistema
$conn->query("SET FOREIGN_KEY_CHECKS = 0");

// 2. Borramos las tablas que están causando los errores #3730 y #1701
$tablas = ['audit_logs', 'kb_articles', 'ticket_comments', 'tickets', 'users', 'assets'];
foreach ($tablas as $t) {
    $conn->query("DROP TABLE IF EXISTS $t");
}

// 3. Recreamos la tabla de usuarios con la estructura limpia
$conn->query("CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role_id INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 4. Recreamos la tabla de tickets con la columna de alertas incluida
$conn->query("CREATE TABLE tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(20) UNIQUE,
    title VARCHAR(255),
    agent_id INT,
    is_read_by_agent TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 5. Creamos al Administrador Maestro (Clave: Admin123*)
$hash = password_hash("Admin123*", PASSWORD_BCRYPT);
$sql = "INSERT INTO users (name, email, password, role_id) VALUES ('Administrador SolidDesk', 'admin@soliddesk.com', '$hash', 1)";

if ($conn->query($sql)) {
    echo "<h2 style='color:green'>✅ ¡SISTEMA REPARADO!</h2>";
    echo "<p>Los candados fueron removidos y el administrador fue creado.</p>";
    echo "<a href='login.php'>IR AL LOGIN AHORA</a>";
} else {
    echo "Error: " . $conn->error;
}

$conn->query("SET FOREIGN_KEY_CHECKS = 1");
?>