<?php
include 'db.php';

// 1. Forzamos la eliminación de restricciones
$conn->query("SET FOREIGN_KEY_CHECKS = 0");

// 2. Borramos las tablas conflictivas para recrearlas sin errores de "Unknown column"
$conn->query("DROP TABLE IF EXISTS tickets");
$conn->query("DROP TABLE IF EXISTS users");

// 3. Recreamos la tabla de USUARIOS con la estructura correcta
$conn->query("CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role_id INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 4. Recreamos la tabla de TICKETS con las columnas de ALERTA y AGENTE
$conn->query("CREATE TABLE tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(20) UNIQUE,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    client_id INT,
    agent_id INT,
    priority_id INT DEFAULT 1,
    status_id INT DEFAULT 1,
    asset_id VARCHAR(255),
    is_read_by_agent TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 5. Insertamos al Administrador con el Hash exacto para PHP
$pass_hash = password_hash("Admin123*", PASSWORD_BCRYPT);
$sql_admin = "INSERT INTO users (name, email, password, role_id) 
              VALUES ('Administrador SolidDesk', 'admin@soliddesk.com', '$pass_hash', 1)";

if ($conn->query($sql_admin)) {
    echo "<h1 style='color:green'>✅ SISTEMA RECONSTRUIDO</h1>";
    echo "<p>Base de datos saneada y Usuario Creado.</p>";
    echo "<p><b>Usuario:</b> admin@soliddesk.com<br><b>Clave:</b> Admin123*</p>";
    echo "<a href='login.php' style='background:blue; color:white; padding:10px; text-decoration:none;'>IR AL LOGIN</a>";
} else {
    echo "Error: " . $conn->error;
}

$conn->query("SET FOREIGN_KEY_CHECKS = 1");
?>