<?php
include 'db.php';

// 1. Desactivamos seguridad por completo para romper el bloqueo #1701 y #3730
$conn->query("SET FOREIGN_KEY_CHECKS = 0");

// 2. Lista de tablas que están bloqueando el sistema
$tablas = ['audit_logs', 'kb_articles', 'ticket_comments', 'tickets', 'users', 'assets'];

foreach ($tablas as $tabla) {
    if ($conn->query("DROP TABLE IF EXISTS $tabla")) {
        echo "✅ Tabla $tabla eliminada.<br>";
    }
}

// 3. Recreamos la tabla de USUARIOS (Limpia)
$conn->query("CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role_id INT NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 4. Recreamos la tabla de TICKETS (Con la columna is_read_by_agent para evitar el error del Dashboard)
$conn->query("CREATE TABLE tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(20) UNIQUE,
    title VARCHAR(255),
    agent_id INT,
    is_read_by_agent TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// 5. Creamos al Administrador (Clave: Admin123*)
$pass = password_hash("Admin123*", PASSWORD_BCRYPT);
$sql_admin = "INSERT INTO users (name, email, password, role_id) VALUES ('Administrador SolidDesk', 'admin@soliddesk.com', '$pass', 1)";

if ($conn->query($sql_admin)) {
    echo "<h2>🚀 ¡SISTEMA REESTABLECIDO!</h2>";
    echo "<p>Ya puedes entrar con: <b>admin@soliddesk.com</b> / <b>Admin123*</b></p>";
    echo "<a href='login.php' style='padding:10px; background:blue; color:white; text-decoration:none;'>IR AL LOGIN</a>";
}

$conn->query("SET FOREIGN_KEY_CHECKS = 1");
?>