<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\Ticket;
use App\Models\TicketPriority;
use Carbon\Carbon;
use Illuminate\Http\Request;
class ReportApiController extends Controller
{
    private function guard(Request $r): void { abort_unless($r->user()->hasAnyRole(['admin','superadmin','jefe_soporte']),403); }
    public function summary(Request $request) {
        $this->guard($request);
        $from = Carbon::parse($request->from ?? now()->startOfMonth());
        $to   = Carbon::parse($request->to   ?? now());
        $tickets = Ticket::with(['status','priority'])->whereBetween('created_at',[$from->startOfDay(),$to->endOfDay()])->get();
        $closed  = $tickets->filter(fn($t)=>$t->status->is_final);
        $breached= $tickets->where('sla_resolution_breached',true);
        $rated   = $tickets->whereNotNull('satisfaction_score');
        return response()->json(['success'=>true,'data'=>[
            'period'         => ['from'=>$from->toDateString(),'to'=>$to->toDateString()],
            'total'          => $tickets->count(), 'open' => $tickets->filter(fn($t)=>!$t->status->is_final)->count(),
            'closed'         => $closed->count(), 'sla_breached' => $breached->count(),
            'sla_compliance' => $closed->count()>0 ? round((($closed->count()-$breached->count())/$closed->count())*100) : 100,
            'avg_satisfaction'=> $rated->count()>0 ? round($rated->avg('satisfaction_score'),1) : null,
            'by_priority'    => $tickets->groupBy('priority.name')->map(fn($g)=>$g->count()),
            'by_status'      => $tickets->groupBy('status.name')->map(fn($g)=>$g->count()),
        ]]);
    }
    public function sla(Request $request) {
        $this->guard($request);
        $data = TicketPriority::active()->get()->map(function($p) {
            $tickets = Ticket::with(['status'])->where('priority_id',$p->id)->get();
            $closed  = $tickets->filter(fn($t)=>$t->status->is_final);
            $breached= $tickets->where('sla_resolution_breached',true);
            $onTime  = $closed->where('sla_resolution_breached',false);
            return ['priority'=>$p->name,'sla_hours'=>$p->sla_resolution_hours,'total'=>$tickets->count(),'closed'=>$closed->count(),'on_time'=>$onTime->count(),'breached'=>$breached->count(),'compliance'=>$closed->count()>0?round(($onTime->count()/$closed->count())*100):100];
        });
        return response()->json(['success'=>true,'data'=>$data]);
    }
}
