<?php
namespace App\Http\Controllers;

use App\Models\Configuration;
use Illuminate\Http\Request;

class ConfigurationController extends Controller
{
    public function index() {
        abort_unless(auth()->user()->hasRole('superadmin') || auth()->user()->hasRole('admin'), 403);
        $groups = [
            'general'    => Configuration::group('general'),
            'mail'       => Configuration::group('mail'),
            'appearance' => Configuration::group('appearance'),
            'sla'        => Configuration::group('sla'),
            'tickets'    => Configuration::group('tickets'),
        ];
        return view('admin.settings.index', compact('groups'));
    }

    public function update(Request $request) {
        abort_unless(auth()->user()->hasRole('superadmin') || auth()->user()->hasRole('admin'), 403);
        foreach ($request->except(['_token', '_method']) as $key => $value) {
            Configuration::set($key, $value);
        }
        Configuration::clearCache();
        return back()->with('success', 'Configuración guardada correctamente.');
    }
}
