<?php
namespace App\Http\Controllers;

use App\Models\TicketPriority;
use Illuminate\Http\Request;

class TicketPriorityController extends Controller
{
    public function index() {
        abort_unless(auth()->user()->hasAnyRole(['admin','superadmin']), 403);
        $priorities = TicketPriority::orderBy('level')->get();
        return view('admin.ticket-config.priorities', compact('priorities'));
    }
    public function store(Request $request) {
        abort_unless(auth()->user()->hasAnyRole(['admin','superadmin']), 403);
        $data = $request->validate(['name'=>'required','level'=>'required|integer|min:1|max:4','color'=>'nullable','sla_response_hours'=>'required|integer|min:1','sla_resolution_hours'=>'required|integer|min:1']);
        TicketPriority::create($data);
        return back()->with('success','Prioridad creada.');
    }
    public function update(Request $request, TicketPriority $ticketPriority) {
        abort_unless(auth()->user()->hasAnyRole(['admin','superadmin']), 403);
        $data = $request->validate(['name'=>'required','level'=>'required|integer','color'=>'nullable','sla_response_hours'=>'required|integer','sla_resolution_hours'=>'required|integer','active'=>'boolean']);
        $ticketPriority->update($data);
        return back()->with('success','Prioridad actualizada.');
    }
}
