<?php
namespace App\Http\Controllers;

use App\Models\TicketStatus;
use Illuminate\Http\Request;

class TicketStatusController extends Controller
{
    public function index() {
        abort_unless(auth()->user()->hasAnyRole(['admin','superadmin']), 403);
        $statuses = TicketStatus::orderBy('order')->get();
        return view('admin.ticket-config.statuses', compact('statuses'));
    }
    public function store(Request $request) {
        abort_unless(auth()->user()->hasAnyRole(['admin','superadmin']), 403);
        $data = $request->validate(['name'=>'required','color'=>'nullable','is_initial'=>'boolean','is_final'=>'boolean','is_pending'=>'boolean','order'=>'integer']);
        TicketStatus::create($data);
        return back()->with('success','Estado creado.');
    }
    public function update(Request $request, TicketStatus $ticketStatus) {
        abort_unless(auth()->user()->hasAnyRole(['admin','superadmin']), 403);
        $data = $request->validate(['name'=>'required','color'=>'nullable','is_initial'=>'boolean','is_final'=>'boolean','is_pending'=>'boolean','order'=>'integer','active'=>'boolean']);
        $ticketStatus->update($data);
        return back()->with('success','Estado actualizado.');
    }
}
