<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Cache\RateLimiter;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ApiRateLimitMiddleware
{
    public function __construct(private RateLimiter $limiter) {}

    public function handle(Request $request, Closure $next, string $tier = 'default'): Response
    {
        $key = $tier . ':' . ($request->user()?->id ?? $request->ip());
        $limits = ['default' => [60,1], 'strict' => [20,1], 'auth' => [10,1]];
        [$max, $decay] = $limits[$tier] ?? $limits['default'];

        if ($this->limiter->tooManyAttempts($key, $max)) {
            return response()->json([
                'success'     => false,
                'message'     => 'Demasiadas solicitudes. Intenta en ' . $this->limiter->availableIn($key) . 's.',
                'retry_after' => $this->limiter->availableIn($key),
            ], 429, ['X-RateLimit-Limit' => $max, 'X-RateLimit-Remaining' => 0, 'Retry-After' => $this->limiter->availableIn($key)]);
        }

        $this->limiter->hit($key, $decay * 60);
        $response  = $next($request);
        $remaining = max(0, $max - $this->limiter->attempts($key));
        return $response->withHeaders(['X-RateLimit-Limit' => $max, 'X-RateLimit-Remaining' => $remaining]);
    }
}
