<?php
namespace App\Http\Resources\Api;
use Illuminate\Http\Resources\Json\JsonResource;
class AssetResource extends JsonResource
{
    public function toArray($request): array {
        return [
            'id'            => $this->id,  'code' => $this->code, 'name' => $this->name,
            'serial_number' => $this->serial_number, 'status' => $this->status, 'status_label' => $this->status_label,
            'category'      => $this->category ? ['id'=>$this->category->id,'name'=>$this->category->name] : null,
            'model'         => $this->model ? ['id'=>$this->model->id,'name'=>$this->model->name,'manufacturer'=>$this->model->manufacturer?->name] : null,
            'assigned_user' => $this->assignedUser ? ['id'=>$this->assignedUser->id,'name'=>$this->assignedUser->name] : null,
            'department'    => $this->department ? ['id'=>$this->department->id,'name'=>$this->department->name] : null,
            'location'        => $this->location,
            'purchase_date'   => $this->purchase_date?->toDateString(),
            'purchase_price'  => $this->purchase_price,
            'warranty_until'  => $this->warranty_until?->toDateString(),
            'warranty_expired'=> $this->isWarrantyExpired(),
            'created_at'      => $this->created_at->toIso8601String(),
        ];
    }
}
