<?php
namespace App\Http\Resources\Api;
use Illuminate\Http\Resources\Json\JsonResource;
class KbArticleResource extends JsonResource
{
    public function toArray($request): array {
        return [
            'id' => $this->id, 'title' => $this->title, 'slug' => $this->slug, 'excerpt' => $this->excerpt,
            'content'      => $this->when(request()->routeIs('api.kb.show'), $this->content),
            'category'     => $this->category ? ['id'=>$this->category->id,'name'=>$this->category->name] : null,
            'author'       => ['id'=>$this->author->id,'name'=>$this->author->name],
            'tags'         => $this->tags_array,
            'views'        => $this->views,
            'helpful_yes'  => $this->helpful_yes, 'helpful_no' => $this->helpful_no, 'helpful_rate' => $this->helpful_rate,
            'featured'     => $this->featured,
            'published_at' => $this->published_at?->toIso8601String(),
        ];
    }
}
