<?php
namespace App\Http\Resources\Api;
use Illuminate\Http\Resources\Json\JsonResource;
class TicketResource extends JsonResource
{
    public function toArray($request): array {
        return [
            'id' => $this->id, 'number' => $this->number, 'title' => $this->title, 'description' => $this->description,
            'status'   => ['id'=>$this->status->id,'name'=>$this->status->name,'color'=>$this->status->color,'is_final'=>$this->status->is_final],
            'priority' => ['id'=>$this->priority->id,'name'=>$this->priority->name,'color'=>$this->priority->color],
            'category' => $this->category ? ['id'=>$this->category->id,'name'=>$this->category->name] : null,
            'type'     => $this->type     ? ['id'=>$this->type->id,'name'=>$this->type->name] : null,
            'requester'=> ['id'=>$this->requester->id,'name'=>$this->requester->name,'email'=>$this->requester->email],
            'assignee' => $this->assignee ? ['id'=>$this->assignee->id,'name'=>$this->assignee->name] : null,
            'department'=> $this->department ? ['id'=>$this->department->id,'name'=>$this->department->name] : null,
            'sla' => [
                'response_due'        => $this->sla_response_due?->toIso8601String(),
                'resolution_due'      => $this->sla_resolution_due?->toIso8601String(),
                'resolution_breached' => (bool)$this->sla_resolution_breached,
            ],
            'satisfaction_score' => $this->satisfaction_score,
            'comments_count'     => $this->comments_count ?? 0,
            'created_at' => $this->created_at->toIso8601String(),
            'updated_at' => $this->updated_at->toIso8601String(),
            'closed_at'  => $this->closed_at?->toIso8601String(),
        ];
    }
}
