<?php
namespace App\Http\Resources\Api;
use Illuminate\Http\Resources\Json\JsonResource;
class UserResource extends JsonResource
{
    public function toArray($request): array {
        return [
            'id'         => $this->id,
            'name'       => $this->name,
            'email'      => $this->email,
            'roles'      => $this->getRoleNames(),
            'department' => $this->department ? ['id'=>$this->department->id,'name'=>$this->department->name] : null,
            'created_at' => $this->created_at->toIso8601String(),
        ];
    }
}
