<?php

namespace App\Livewire\Dashboard;

use Livewire\Component;
use App\Models\User;

class DashboardMain extends Component
{
    public function render()
    {
        $user = auth()->user();
        $data = [];

        if ($user->hasAnyRole(['admin', 'gerente'])) {
            $data['totalUsuarios'] = User::count();
            $data['usuariosActivos'] = User::where('is_active', true)->count();
            $data['totalProcesos'] = 0; // Se actualiza en Sprint 3
            $data['procesosActivos'] = 0;
            $data['totalClientes'] = \App\Models\ClienteCorporativo::count();
            $data['totalDeudores'] = \App\Models\Deudor::count();
        }

        if ($user->hasAnyRole(['sustanciador', 'dependiente', 'asistente'])) {
            $data['misProcesos'] = 0; // Se actualiza en Sprint 3
            $data['pendientes'] = 0;
            $data['alertas'] = 0;
        }

        return view('livewire.dashboard.dashboard-main', [
            'data' => $data,
            'userRole' => $user->getRoleNames()->first() ?? 'sin-rol',
        ]);
    }
}
