<?php
namespace App\Livewire;

use App\Models\NexusNotification;
use Livewire\Component;

class NotificationBell extends Component
{
    public bool $open = false;

    public function toggle(): void
    {
        $this->open = !$this->open;
    }

    public function markRead(int $id): void
    {
        NexusNotification::where('id', $id)
            ->where('user_id', auth()->id())
            ->first()?->markAsRead();
    }

    public function markAllRead(): void
    {
        NexusNotification::forUser(auth()->id())
            ->unread()
            ->update(['read_at' => now()]);
        $this->open = false;
    }

    public function render()
    {
        $notifications = NexusNotification::forUser(auth()->id())
            ->latest()
            ->limit(15)
            ->get();

        $unreadCount = $notifications->whereNull('read_at')->count();

        return view('livewire.notification-bell', compact('notifications', 'unreadCount'));
    }
}
