<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class AgentGroup extends Model
{
    use LogsActivity;

    protected $fillable = ['name', 'description', 'auto_assign', 'active'];

    protected function casts(): array {
        return ['auto_assign' => 'boolean', 'active' => 'boolean'];
    }

    public function users(): BelongsToMany {
        return $this->belongsToMany(User::class, 'agent_group_user');
    }

    public function scopeActive($query) {
        return $query->where('active', true);
    }

    public function getActivitylogOptions(): LogOptions {
        return LogOptions::defaults()
            ->logOnly(['name', 'active', 'auto_assign'])
            ->logOnlyDirty()
            ->setDescriptionForEvent(fn(string $e) => "Grupo {$this->name}: {$e}");
    }
}
