<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AiClassification extends Model
{
    protected $fillable = [
        'ticket_id','suggested_category_id','suggested_priority_id',
        'category_confidence','priority_confidence',
        'kb_suggestions','keywords_detected','applied',
    ];
    protected function casts(): array {
        return ['kb_suggestions' => 'array', 'keywords_detected' => 'array', 'applied' => 'boolean'];
    }

    public function ticket(): BelongsTo             { return $this->belongsTo(Ticket::class); }
    public function suggestedCategory(): BelongsTo  { return $this->belongsTo(TicketCategory::class, 'suggested_category_id'); }
    public function suggestedPriority(): BelongsTo  { return $this->belongsTo(TicketPriority::class, 'suggested_priority_id'); }

    public function getIsConfidentAttribute(): bool {
        return $this->category_confidence >= 40 || $this->priority_confidence >= 40;
    }
}
